// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// A reference from one resource to another
    /// Based on [FHIR Reference](https://www.hl7.org/fhir/R4/references.html)
    /// </summary>
    public partial class FhirR4Reference : FhirR4Element
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4Reference"/>. </summary>
        public FhirR4Reference()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Reference"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="reference"> Literal reference, Relative, internal or absolute URL. </param>
        /// <param name="type"> Type the reference refers to (e.g. "Patient"). </param>
        /// <param name="identifier"> Logical reference, when literal reference is not known. </param>
        /// <param name="display"> Text alternative for the resource. </param>
        internal FhirR4Reference(string id, IList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, string reference, string type, FhirR4Identifier identifier, string display) : base(id, extension, serializedAdditionalRawData)
        {
            Reference = reference;
            Type = type;
            Identifier = identifier;
            Display = display;
        }

        /// <summary> Literal reference, Relative, internal or absolute URL. </summary>
        public string Reference { get; set; }
        /// <summary> Type the reference refers to (e.g. "Patient"). </summary>
        public string Type { get; set; }
        /// <summary> Logical reference, when literal reference is not known. </summary>
        public FhirR4Identifier Identifier { get; set; }
        /// <summary> Text alternative for the resource. </summary>
        public string Display { get; set; }
    }
}
