// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// A set of ordered Quantities defined by a low and high limit
    /// Based on [FHIR Range](https://www.hl7.org/fhir/R4/datatypes.html#Range)
    /// </summary>
    public partial class FhirR4Range : FhirR4Element
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4Range"/>. </summary>
        public FhirR4Range()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Range"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="low"> Low limit. </param>
        /// <param name="high"> High limit. </param>
        internal FhirR4Range(string id, IList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, FhirR4Quantity low, FhirR4Quantity high) : base(id, extension, serializedAdditionalRawData)
        {
            Low = low;
            High = high;
        }

        /// <summary> Low limit. </summary>
        public FhirR4Quantity Low { get; set; }
        /// <summary> High limit. </summary>
        public FhirR4Quantity High { get; set; }
    }
}
