// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// A measured or measurable amount
    /// Based on [FHIR Quantity](https://www.hl7.org/fhir/R4/datatypes.html#Quantity)
    /// </summary>
    public partial class FhirR4Quantity : FhirR4Element
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4Quantity"/>. </summary>
        public FhirR4Quantity()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Quantity"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="value"> Numerical value (with implicit precision). </param>
        /// <param name="comparator"> &lt; | &lt;= | &gt;= | &gt; - how to understand the value. </param>
        /// <param name="unit"> Unit representation. </param>
        /// <param name="system"> System that defines coded unit form. </param>
        /// <param name="code"> Coded form of the unit. </param>
        internal FhirR4Quantity(string id, IList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, double? value, string comparator, string unit, string system, string code) : base(id, extension, serializedAdditionalRawData)
        {
            Value = value;
            Comparator = comparator;
            Unit = unit;
            System = system;
            Code = code;
        }

        /// <summary> Numerical value (with implicit precision). </summary>
        public double? Value { get; set; }
        /// <summary> &lt; | &lt;= | &gt;= | &gt; - how to understand the value. </summary>
        public string Comparator { get; set; }
        /// <summary> Unit representation. </summary>
        public string Unit { get; set; }
        /// <summary> System that defines coded unit form. </summary>
        public string System { get; set; }
        /// <summary> Coded form of the unit. </summary>
        public string Code { get; set; }
    }
}
