// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Provides guide for interpretation of component result
    /// Based on [FHIR Observation.referenceRange](https://www.hl7.org/fhir/R4/observation.html)
    /// </summary>
    public partial class FhirR4ObservationReferenceRange
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FhirR4ObservationReferenceRange"/>. </summary>
        internal FhirR4ObservationReferenceRange()
        {
            AppliesTo = new ChangeTrackingList<FhirR4CodeableConcept>();
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4ObservationReferenceRange"/>. </summary>
        /// <param name="low"> Low Range, if relevant. </param>
        /// <param name="high"> High Range, if relevant. </param>
        /// <param name="type"> Reference range qualifier. </param>
        /// <param name="appliesTo"> Reference range population. </param>
        /// <param name="age"> Applicable age range, if relevant. </param>
        /// <param name="text"> Text based reference range in an observation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FhirR4ObservationReferenceRange(FhirR4Quantity low, FhirR4Quantity high, FhirR4CodeableConcept type, IReadOnlyList<FhirR4CodeableConcept> appliesTo, FhirR4Range age, string text, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Low = low;
            High = high;
            Type = type;
            AppliesTo = appliesTo;
            Age = age;
            Text = text;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Low Range, if relevant. </summary>
        public FhirR4Quantity Low { get; }
        /// <summary> High Range, if relevant. </summary>
        public FhirR4Quantity High { get; }
        /// <summary> Reference range qualifier. </summary>
        public FhirR4CodeableConcept Type { get; }
        /// <summary> Reference range population. </summary>
        public IReadOnlyList<FhirR4CodeableConcept> AppliesTo { get; }
        /// <summary> Applicable age range, if relevant. </summary>
        public FhirR4Range Age { get; }
        /// <summary> Text based reference range in an observation. </summary>
        public string Text { get; }
    }
}
