// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Health.Insights.RadiologyInsights
{
    public partial class FhirR4ObservationComponent : IUtf8JsonSerializable, IJsonModel<FhirR4ObservationComponent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FhirR4ObservationComponent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FhirR4ObservationComponent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4ObservationComponent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FhirR4ObservationComponent)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("code"u8);
            writer.WriteObjectValue(Code, options);
            if (Optional.IsDefined(ValueQuantity))
            {
                writer.WritePropertyName("valueQuantity"u8);
                writer.WriteObjectValue(ValueQuantity, options);
            }
            if (Optional.IsDefined(ValueCodeableConcept))
            {
                writer.WritePropertyName("valueCodeableConcept"u8);
                writer.WriteObjectValue(ValueCodeableConcept, options);
            }
            if (Optional.IsDefined(ValueString))
            {
                writer.WritePropertyName("valueString"u8);
                writer.WriteStringValue(ValueString);
            }
            if (Optional.IsDefined(ValueBoolean))
            {
                writer.WritePropertyName("valueBoolean"u8);
                writer.WriteBooleanValue(ValueBoolean.Value);
            }
            if (Optional.IsDefined(ValueInteger))
            {
                writer.WritePropertyName("valueInteger"u8);
                writer.WriteNumberValue(ValueInteger.Value);
            }
            if (Optional.IsDefined(ValueRange))
            {
                writer.WritePropertyName("valueRange"u8);
                writer.WriteObjectValue(ValueRange, options);
            }
            if (Optional.IsDefined(ValueRatio))
            {
                writer.WritePropertyName("valueRatio"u8);
                writer.WriteObjectValue(ValueRatio, options);
            }
            if (Optional.IsDefined(ValueSampledData))
            {
                writer.WritePropertyName("valueSampledData"u8);
                writer.WriteObjectValue(ValueSampledData, options);
            }
            if (Optional.IsDefined(ValueTime))
            {
                writer.WritePropertyName("valueTime"u8);
                writer.WriteStringValue(ValueTime.Value, "T");
            }
            if (Optional.IsDefined(ValueDateTime))
            {
                writer.WritePropertyName("valueDateTime"u8);
                writer.WriteStringValue(ValueDateTime);
            }
            if (Optional.IsDefined(ValuePeriod))
            {
                writer.WritePropertyName("valuePeriod"u8);
                writer.WriteObjectValue(ValuePeriod, options);
            }
            if (Optional.IsDefined(ValueReference))
            {
                writer.WritePropertyName("valueReference"u8);
                writer.WriteObjectValue(ValueReference, options);
            }
            if (Optional.IsDefined(DataAbsentReason))
            {
                writer.WritePropertyName("dataAbsentReason"u8);
                writer.WriteObjectValue(DataAbsentReason, options);
            }
            if (Optional.IsCollectionDefined(Interpretation))
            {
                writer.WritePropertyName("interpretation"u8);
                writer.WriteStartArray();
                foreach (var item in Interpretation)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ReferenceRange))
            {
                writer.WritePropertyName("referenceRange"u8);
                writer.WriteStartArray();
                foreach (var item in ReferenceRange)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
        }

        FhirR4ObservationComponent IJsonModel<FhirR4ObservationComponent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4ObservationComponent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FhirR4ObservationComponent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFhirR4ObservationComponent(document.RootElement, options);
        }

        internal static FhirR4ObservationComponent DeserializeFhirR4ObservationComponent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            FhirR4CodeableConcept code = default;
            FhirR4Quantity valueQuantity = default;
            FhirR4CodeableConcept valueCodeableConcept = default;
            string valueString = default;
            bool? valueBoolean = default;
            int? valueInteger = default;
            FhirR4Range valueRange = default;
            FhirR4Ratio valueRatio = default;
            FhirR4SampledData valueSampledData = default;
            TimeSpan? valueTime = default;
            string valueDateTime = default;
            FhirR4Period valuePeriod = default;
            FhirR4Reference valueReference = default;
            FhirR4CodeableConcept dataAbsentReason = default;
            IReadOnlyList<FhirR4CodeableConcept> interpretation = default;
            IReadOnlyList<FhirR4ObservationReferenceRange> referenceRange = default;
            string id = default;
            IList<FhirR4Extension> extension = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("code"u8))
                {
                    code = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("valueQuantity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valueQuantity = FhirR4Quantity.DeserializeFhirR4Quantity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("valueCodeableConcept"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valueCodeableConcept = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("valueString"u8))
                {
                    valueString = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("valueBoolean"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valueBoolean = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("valueInteger"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valueInteger = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("valueRange"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valueRange = FhirR4Range.DeserializeFhirR4Range(property.Value, options);
                    continue;
                }
                if (property.NameEquals("valueRatio"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valueRatio = FhirR4Ratio.DeserializeFhirR4Ratio(property.Value, options);
                    continue;
                }
                if (property.NameEquals("valueSampledData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valueSampledData = FhirR4SampledData.DeserializeFhirR4SampledData(property.Value, options);
                    continue;
                }
                if (property.NameEquals("valueTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valueTime = property.Value.GetTimeSpan("T");
                    continue;
                }
                if (property.NameEquals("valueDateTime"u8))
                {
                    valueDateTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("valuePeriod"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valuePeriod = FhirR4Period.DeserializeFhirR4Period(property.Value, options);
                    continue;
                }
                if (property.NameEquals("valueReference"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    valueReference = FhirR4Reference.DeserializeFhirR4Reference(property.Value, options);
                    continue;
                }
                if (property.NameEquals("dataAbsentReason"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataAbsentReason = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("interpretation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4CodeableConcept> array = new List<FhirR4CodeableConcept>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(item, options));
                    }
                    interpretation = array;
                    continue;
                }
                if (property.NameEquals("referenceRange"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4ObservationReferenceRange> array = new List<FhirR4ObservationReferenceRange>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4ObservationReferenceRange.DeserializeFhirR4ObservationReferenceRange(item, options));
                    }
                    referenceRange = array;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("extension"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Extension> array = new List<FhirR4Extension>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Extension.DeserializeFhirR4Extension(item, options));
                    }
                    extension = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new FhirR4ObservationComponent(
                id,
                extension ?? new ChangeTrackingList<FhirR4Extension>(),
                serializedAdditionalRawData,
                code,
                valueQuantity,
                valueCodeableConcept,
                valueString,
                valueBoolean,
                valueInteger,
                valueRange,
                valueRatio,
                valueSampledData,
                valueTime,
                valueDateTime,
                valuePeriod,
                valueReference,
                dataAbsentReason,
                interpretation ?? new ChangeTrackingList<FhirR4CodeableConcept>(),
                referenceRange ?? new ChangeTrackingList<FhirR4ObservationReferenceRange>());
        }

        BinaryData IPersistableModel<FhirR4ObservationComponent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4ObservationComponent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FhirR4ObservationComponent)} does not support writing '{options.Format}' format.");
            }
        }

        FhirR4ObservationComponent IPersistableModel<FhirR4ObservationComponent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4ObservationComponent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFhirR4ObservationComponent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FhirR4ObservationComponent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FhirR4ObservationComponent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new FhirR4ObservationComponent FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFhirR4ObservationComponent(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
