// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Detailed information about observations
    /// Based on [FHIR Observation](https://www.hl7.org/fhir/R4/observation.html)
    /// </summary>
    public partial class FhirR4Observation : FhirR4DomainResource
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4Observation"/>. </summary>
        /// <param name="status"> registered | preliminary | final | amended +. </param>
        /// <param name="code"> Type of observation (code / type). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="code"/> is null. </exception>
        internal FhirR4Observation(ObservationStatusCodeType status, FhirR4CodeableConcept code) : base("Observation")
        {
            Argument.AssertNotNull(code, nameof(code));

            Identifier = new ChangeTrackingList<FhirR4Identifier>();
            Status = status;
            Category = new ChangeTrackingList<FhirR4CodeableConcept>();
            Code = code;
            Interpretation = new ChangeTrackingList<FhirR4CodeableConcept>();
            Note = new ChangeTrackingList<FhirR4Annotation>();
            ReferenceRange = new ChangeTrackingList<FhirR4ObservationReferenceRange>();
            HasMember = new ChangeTrackingList<FhirR4Reference>();
            DerivedFrom = new ChangeTrackingList<FhirR4Reference>();
            Component = new ChangeTrackingList<FhirR4ObservationComponent>();
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Observation"/>. </summary>
        /// <param name="resourceType"> The type of resource. </param>
        /// <param name="id"> Resource Id. </param>
        /// <param name="meta"> Metadata about the resource. </param>
        /// <param name="implicitRules"> A set of rules under which this content was created. </param>
        /// <param name="language"> Language of the resource content. </param>
        /// <param name="additionalProperties"> Additional Properties. </param>
        /// <param name="text"> Text summary of the resource, for human interpretation. </param>
        /// <param name="contained"> Contained, inline Resources. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="modifierExtension"> Extensions that cannot be ignored. </param>
        /// <param name="identifier"> Business Identifier for observation. </param>
        /// <param name="status"> registered | preliminary | final | amended +. </param>
        /// <param name="category"> Classification of  type of observation. </param>
        /// <param name="code"> Type of observation (code / type). </param>
        /// <param name="subject"> Who and/or what the observation is about. </param>
        /// <param name="encounter"> Healthcare event during which this observation is made. </param>
        /// <param name="effectiveDateTime"> Clinically relevant time/time-period for observation. </param>
        /// <param name="effectivePeriod"> Clinically relevant time/time-period for observation. </param>
        /// <param name="effectiveInstant"> Clinically relevant time/time-period for observation. </param>
        /// <param name="issued"> Date/Time this version was made available. </param>
        /// <param name="valueQuantity"> Actual result. </param>
        /// <param name="valueCodeableConcept"> Actual result. </param>
        /// <param name="valueString"> Actual result. </param>
        /// <param name="valueBoolean"> Actual result. </param>
        /// <param name="valueInteger"> Actual result. </param>
        /// <param name="valueRange"> Actual result. </param>
        /// <param name="valueRatio"> Actual result. </param>
        /// <param name="valueSampledData"> Actual result. </param>
        /// <param name="valueTime"> Actual result. </param>
        /// <param name="valueDateTime"> Actual result. </param>
        /// <param name="valuePeriod"> Actual result. </param>
        /// <param name="dataAbsentReason"> Why the result is missing. </param>
        /// <param name="interpretation"> High, low, normal, etc. </param>
        /// <param name="note"> Comments about the observation. </param>
        /// <param name="bodySite"> Observed body part. </param>
        /// <param name="method"> How it was done. </param>
        /// <param name="referenceRange"> Provides guide for interpretation. </param>
        /// <param name="hasMember"> Related resource that belongs to the Observation group. </param>
        /// <param name="derivedFrom"> Related measurements the observation is made from. </param>
        /// <param name="component"> Component results. </param>
        internal FhirR4Observation(string resourceType, string id, FhirR4Meta meta, string implicitRules, string language, IDictionary<string, BinaryData> additionalProperties, FhirR4Narrative text, IReadOnlyList<FhirR4Resource> contained, IReadOnlyList<FhirR4Extension> extension, IReadOnlyList<FhirR4Extension> modifierExtension, IReadOnlyList<FhirR4Identifier> identifier, ObservationStatusCodeType status, IReadOnlyList<FhirR4CodeableConcept> category, FhirR4CodeableConcept code, FhirR4Reference subject, FhirR4Reference encounter, string effectiveDateTime, FhirR4Period effectivePeriod, string effectiveInstant, string issued, FhirR4Quantity valueQuantity, FhirR4CodeableConcept valueCodeableConcept, string valueString, bool? valueBoolean, int? valueInteger, FhirR4Range valueRange, FhirR4Ratio valueRatio, FhirR4SampledData valueSampledData, TimeSpan? valueTime, string valueDateTime, FhirR4Period valuePeriod, FhirR4CodeableConcept dataAbsentReason, IReadOnlyList<FhirR4CodeableConcept> interpretation, IReadOnlyList<FhirR4Annotation> note, FhirR4CodeableConcept bodySite, FhirR4CodeableConcept method, IReadOnlyList<FhirR4ObservationReferenceRange> referenceRange, IReadOnlyList<FhirR4Reference> hasMember, IReadOnlyList<FhirR4Reference> derivedFrom, IReadOnlyList<FhirR4ObservationComponent> component) : base(resourceType, id, meta, implicitRules, language, additionalProperties, text, contained, extension, modifierExtension)
        {
            Identifier = identifier;
            Status = status;
            Category = category;
            Code = code;
            Subject = subject;
            Encounter = encounter;
            EffectiveDateTime = effectiveDateTime;
            EffectivePeriod = effectivePeriod;
            EffectiveInstant = effectiveInstant;
            Issued = issued;
            ValueQuantity = valueQuantity;
            ValueCodeableConcept = valueCodeableConcept;
            ValueString = valueString;
            ValueBoolean = valueBoolean;
            ValueInteger = valueInteger;
            ValueRange = valueRange;
            ValueRatio = valueRatio;
            ValueSampledData = valueSampledData;
            ValueTime = valueTime;
            ValueDateTime = valueDateTime;
            ValuePeriod = valuePeriod;
            DataAbsentReason = dataAbsentReason;
            Interpretation = interpretation;
            Note = note;
            BodySite = bodySite;
            Method = method;
            ReferenceRange = referenceRange;
            HasMember = hasMember;
            DerivedFrom = derivedFrom;
            Component = component;
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Observation"/> for deserialization. </summary>
        internal FhirR4Observation()
        {
        }

        /// <summary> Business Identifier for observation. </summary>
        public IReadOnlyList<FhirR4Identifier> Identifier { get; }
        /// <summary> registered | preliminary | final | amended +. </summary>
        public ObservationStatusCodeType Status { get; }
        /// <summary> Classification of  type of observation. </summary>
        public IReadOnlyList<FhirR4CodeableConcept> Category { get; }
        /// <summary> Type of observation (code / type). </summary>
        public FhirR4CodeableConcept Code { get; }
        /// <summary> Who and/or what the observation is about. </summary>
        public FhirR4Reference Subject { get; }
        /// <summary> Healthcare event during which this observation is made. </summary>
        public FhirR4Reference Encounter { get; }
        /// <summary> Clinically relevant time/time-period for observation. </summary>
        public string EffectiveDateTime { get; }
        /// <summary> Clinically relevant time/time-period for observation. </summary>
        public FhirR4Period EffectivePeriod { get; }
        /// <summary> Clinically relevant time/time-period for observation. </summary>
        public string EffectiveInstant { get; }
        /// <summary> Date/Time this version was made available. </summary>
        public string Issued { get; }
        /// <summary> Actual result. </summary>
        public FhirR4Quantity ValueQuantity { get; }
        /// <summary> Actual result. </summary>
        public FhirR4CodeableConcept ValueCodeableConcept { get; }
        /// <summary> Actual result. </summary>
        public string ValueString { get; }
        /// <summary> Actual result. </summary>
        public bool? ValueBoolean { get; }
        /// <summary> Actual result. </summary>
        public int? ValueInteger { get; }
        /// <summary> Actual result. </summary>
        public FhirR4Range ValueRange { get; }
        /// <summary> Actual result. </summary>
        public FhirR4Ratio ValueRatio { get; }
        /// <summary> Actual result. </summary>
        public FhirR4SampledData ValueSampledData { get; }
        /// <summary> Actual result. </summary>
        public TimeSpan? ValueTime { get; }
        /// <summary> Actual result. </summary>
        public string ValueDateTime { get; }
        /// <summary> Actual result. </summary>
        public FhirR4Period ValuePeriod { get; }
        /// <summary> Why the result is missing. </summary>
        public FhirR4CodeableConcept DataAbsentReason { get; }
        /// <summary> High, low, normal, etc. </summary>
        public IReadOnlyList<FhirR4CodeableConcept> Interpretation { get; }
        /// <summary> Comments about the observation. </summary>
        public IReadOnlyList<FhirR4Annotation> Note { get; }
        /// <summary> Observed body part. </summary>
        public FhirR4CodeableConcept BodySite { get; }
        /// <summary> How it was done. </summary>
        public FhirR4CodeableConcept Method { get; }
        /// <summary> Provides guide for interpretation. </summary>
        public IReadOnlyList<FhirR4ObservationReferenceRange> ReferenceRange { get; }
        /// <summary> Related resource that belongs to the Observation group. </summary>
        public IReadOnlyList<FhirR4Reference> HasMember { get; }
        /// <summary> Related measurements the observation is made from. </summary>
        public IReadOnlyList<FhirR4Reference> DerivedFrom { get; }
        /// <summary> Component results. </summary>
        public IReadOnlyList<FhirR4ObservationComponent> Component { get; }
    }
}
