// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Any resource that is a [DomainResource](https://www.hl7.org/fhir/domainresource.html) may include a human-readable narrative that contains a summary of the resource and may be used to represent the content of the resource to a human.
    /// Based on [FHIR Narrative](https://www.hl7.org/fhir/R4/narrative.html#Narrative)
    /// </summary>
    public partial class FhirR4Narrative : FhirR4Element
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4Narrative"/>. </summary>
        /// <param name="status"> generated, extensions, additional, empty. </param>
        /// <param name="div"> xhtml. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="status"/> or <paramref name="div"/> is null. </exception>
        internal FhirR4Narrative(string status, string div)
        {
            Argument.AssertNotNull(status, nameof(status));
            Argument.AssertNotNull(div, nameof(div));

            Status = status;
            Div = div;
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Narrative"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="status"> generated, extensions, additional, empty. </param>
        /// <param name="div"> xhtml. </param>
        internal FhirR4Narrative(string id, IList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, string status, string div) : base(id, extension, serializedAdditionalRawData)
        {
            Status = status;
            Div = div;
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Narrative"/> for deserialization. </summary>
        internal FhirR4Narrative()
        {
        }

        /// <summary> generated, extensions, additional, empty. </summary>
        public string Status { get; }
        /// <summary> xhtml. </summary>
        public string Div { get; }
    }
}
