// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Metadata about a resource
    /// Based on [FHIR Meta](https://www.hl7.org/fhir/R4/resource.html#Meta)
    /// </summary>
    public partial class FhirR4Meta
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FhirR4Meta"/>. </summary>
        public FhirR4Meta()
        {
            Profile = new ChangeTrackingList<string>();
            Security = new ChangeTrackingList<FhirR4Coding>();
            Tag = new ChangeTrackingList<FhirR4Coding>();
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Meta"/>. </summary>
        /// <param name="versionId"> The version specific identifier, as it appears in the version portion of the URL. This value changes when the resource is created, updated, or deleted. </param>
        /// <param name="lastUpdated"> When the resource last changed - e.g. when the version changed. </param>
        /// <param name="source"> A uri that identifies the source system of the resource. This provides a minimal amount of Provenance information that can be used to track or differentiate the source of information in the resource. The source may identify another FHIR server, document, message, database, etc. </param>
        /// <param name="profile"> A list of profiles (references to [StructureDefinition](https://www.hl7.org/fhir/structuredefinition.html) resources) that this resource claims to conform to. The URL is a reference to [StructureDefinition.url](https://www.hl7.org/fhir/structuredefinition-definitions.html#StructureDefinition.url). </param>
        /// <param name="security"> Security labels applied to this resource. These tags connect specific resources to the overall security policy and infrastructure. </param>
        /// <param name="tag"> Tags applied to this resource. Tags are intended to be used to identify and relate resources to process and workflow, and applications are not required to consider the tags when interpreting the meaning of a resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FhirR4Meta(string versionId, string lastUpdated, string source, IList<string> profile, IList<FhirR4Coding> security, IList<FhirR4Coding> tag, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            VersionId = versionId;
            LastUpdated = lastUpdated;
            Source = source;
            Profile = profile;
            Security = security;
            Tag = tag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The version specific identifier, as it appears in the version portion of the URL. This value changes when the resource is created, updated, or deleted. </summary>
        public string VersionId { get; set; }
        /// <summary> When the resource last changed - e.g. when the version changed. </summary>
        public string LastUpdated { get; set; }
        /// <summary> A uri that identifies the source system of the resource. This provides a minimal amount of Provenance information that can be used to track or differentiate the source of information in the resource. The source may identify another FHIR server, document, message, database, etc. </summary>
        public string Source { get; set; }
        /// <summary> A list of profiles (references to [StructureDefinition](https://www.hl7.org/fhir/structuredefinition.html) resources) that this resource claims to conform to. The URL is a reference to [StructureDefinition.url](https://www.hl7.org/fhir/structuredefinition-definitions.html#StructureDefinition.url). </summary>
        public IList<string> Profile { get; }
        /// <summary> Security labels applied to this resource. These tags connect specific resources to the overall security policy and infrastructure. </summary>
        public IList<FhirR4Coding> Security { get; }
        /// <summary> Tags applied to this resource. Tags are intended to be used to identify and relate resources to process and workflow, and applications are not required to consider the tags when interpreting the meaning of a resource. </summary>
        public IList<FhirR4Coding> Tag { get; }
    }
}
