// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Base for all elements
    /// Based on [FHIR Element](https://www.hl7.org/fhir/datatypes.html#Element)
    /// </summary>
    public partial class FhirR4Extension : FhirR4Element
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4Extension"/>. </summary>
        /// <param name="url"> Source of the definition for the extension code - a logical name or a URL. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="url"/> is null. </exception>
        public FhirR4Extension(string url)
        {
            Argument.AssertNotNull(url, nameof(url));

            Url = url;
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Extension"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="url"> Source of the definition for the extension code - a logical name or a URL. </param>
        /// <param name="valueQuantity"> Value as Quantity. </param>
        /// <param name="valueCodeableConcept"> Value as CodeableConcept. </param>
        /// <param name="valueString"> Value as string. </param>
        /// <param name="valueBoolean"> Value as boolean. </param>
        /// <param name="valueInteger"> Value as integer. </param>
        /// <param name="valueRange"> Value as Range. </param>
        /// <param name="valueRatio"> Value as Ratio. </param>
        /// <param name="valueSampledData"> Value as SampledData. </param>
        /// <param name="valueTime"> Value as time (hh:mm:ss). </param>
        /// <param name="valueDateTime"> Value as dateTime. </param>
        /// <param name="valuePeriod"> Value as Period. </param>
        /// <param name="valueReference"> Value as reference. </param>
        internal FhirR4Extension(string id, IList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, string url, FhirR4Quantity valueQuantity, FhirR4CodeableConcept valueCodeableConcept, string valueString, bool? valueBoolean, int? valueInteger, FhirR4Range valueRange, FhirR4Ratio valueRatio, FhirR4SampledData valueSampledData, TimeSpan? valueTime, string valueDateTime, FhirR4Period valuePeriod, FhirR4Reference valueReference) : base(id, extension, serializedAdditionalRawData)
        {
            Url = url;
            ValueQuantity = valueQuantity;
            ValueCodeableConcept = valueCodeableConcept;
            ValueString = valueString;
            ValueBoolean = valueBoolean;
            ValueInteger = valueInteger;
            ValueRange = valueRange;
            ValueRatio = valueRatio;
            ValueSampledData = valueSampledData;
            ValueTime = valueTime;
            ValueDateTime = valueDateTime;
            ValuePeriod = valuePeriod;
            ValueReference = valueReference;
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Extension"/> for deserialization. </summary>
        internal FhirR4Extension()
        {
        }

        /// <summary> Source of the definition for the extension code - a logical name or a URL. </summary>
        public string Url { get; set; }
        /// <summary> Value as Quantity. </summary>
        public FhirR4Quantity ValueQuantity { get; set; }
        /// <summary> Value as CodeableConcept. </summary>
        public FhirR4CodeableConcept ValueCodeableConcept { get; set; }
        /// <summary> Value as string. </summary>
        public string ValueString { get; set; }
        /// <summary> Value as boolean. </summary>
        public bool? ValueBoolean { get; set; }
        /// <summary> Value as integer. </summary>
        public int? ValueInteger { get; set; }
        /// <summary> Value as Range. </summary>
        public FhirR4Range ValueRange { get; set; }
        /// <summary> Value as Ratio. </summary>
        public FhirR4Ratio ValueRatio { get; set; }
        /// <summary> Value as SampledData. </summary>
        public FhirR4SampledData ValueSampledData { get; set; }
        /// <summary> Value as time (hh:mm:ss). </summary>
        public TimeSpan? ValueTime { get; set; }
        /// <summary> Value as dateTime. </summary>
        public string ValueDateTime { get; set; }
        /// <summary> Value as Period. </summary>
        public FhirR4Period ValuePeriod { get; set; }
        /// <summary> Value as reference. </summary>
        public FhirR4Reference ValueReference { get; set; }
    }
}
