// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Contact details (See: https://www.hl7.org/fhir/R4/metadatatypes.html#ContactDetail). </summary>
    public partial class FhirR4ContactDetail : FhirR4Element
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4ContactDetail"/>. </summary>
        internal FhirR4ContactDetail()
        {
            Telecom = new ChangeTrackingList<FhirR4ContactPoint>();
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4ContactDetail"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="name"> Name of an individual to contact. </param>
        /// <param name="telecom"> Contact details for individual or organization. </param>
        internal FhirR4ContactDetail(string id, IList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, string name, IReadOnlyList<FhirR4ContactPoint> telecom) : base(id, extension, serializedAdditionalRawData)
        {
            Name = name;
            Telecom = telecom;
        }

        /// <summary> Name of an individual to contact. </summary>
        public string Name { get; }
        /// <summary> Contact details for individual or organization. </summary>
        public IReadOnlyList<FhirR4ContactPoint> Telecom { get; }
    }
}
