// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Stage/grade, usually assessed formally
    /// Based on [FHIR Condition.Stage](https://www.hl7.org/fhir/R4/condition.html)
    /// </summary>
    public partial class FhirR4ConditionStage
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="FhirR4ConditionStage"/>. </summary>
        internal FhirR4ConditionStage()
        {
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4ConditionStage"/>. </summary>
        /// <param name="summary"> Simple summary (disease specific). </param>
        /// <param name="type"> Kind of staging. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal FhirR4ConditionStage(FhirR4CodeableConcept summary, FhirR4CodeableConcept type, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Summary = summary;
            Type = type;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Simple summary (disease specific). </summary>
        public FhirR4CodeableConcept Summary { get; }
        /// <summary> Kind of staging. </summary>
        public FhirR4CodeableConcept Type { get; }
    }
}
