// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Health.Insights.RadiologyInsights
{
    public partial class FhirR4Condition : IUtf8JsonSerializable, IJsonModel<FhirR4Condition>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<FhirR4Condition>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<FhirR4Condition>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4Condition>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FhirR4Condition)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsCollectionDefined(Identifier))
            {
                writer.WritePropertyName("identifier"u8);
                writer.WriteStartArray();
                foreach (var item in Identifier)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ClinicalStatus))
            {
                writer.WritePropertyName("clinicalStatus"u8);
                writer.WriteObjectValue(ClinicalStatus, options);
            }
            if (Optional.IsDefined(VerificationStatus))
            {
                writer.WritePropertyName("verificationStatus"u8);
                writer.WriteObjectValue(VerificationStatus, options);
            }
            if (Optional.IsCollectionDefined(Category))
            {
                writer.WritePropertyName("category"u8);
                writer.WriteStartArray();
                foreach (var item in Category)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Severity))
            {
                writer.WritePropertyName("severity"u8);
                writer.WriteObjectValue(Severity, options);
            }
            if (Optional.IsDefined(Code))
            {
                writer.WritePropertyName("code"u8);
                writer.WriteObjectValue(Code, options);
            }
            if (Optional.IsCollectionDefined(BodySite))
            {
                writer.WritePropertyName("bodySite"u8);
                writer.WriteStartArray();
                foreach (var item in BodySite)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Encounter))
            {
                writer.WritePropertyName("encounter"u8);
                writer.WriteObjectValue(Encounter, options);
            }
            if (Optional.IsDefined(OnsetDateTime))
            {
                writer.WritePropertyName("onsetDateTime"u8);
                writer.WriteStringValue(OnsetDateTime);
            }
            if (Optional.IsDefined(OnsetAge))
            {
                writer.WritePropertyName("onsetAge"u8);
                writer.WriteObjectValue(OnsetAge, options);
            }
            if (Optional.IsDefined(OnsetPeriod))
            {
                writer.WritePropertyName("onsetPeriod"u8);
                writer.WriteObjectValue(OnsetPeriod, options);
            }
            if (Optional.IsDefined(OnsetRange))
            {
                writer.WritePropertyName("onsetRange"u8);
                writer.WriteObjectValue(OnsetRange, options);
            }
            if (Optional.IsDefined(OnsetString))
            {
                writer.WritePropertyName("onsetString"u8);
                writer.WriteStringValue(OnsetString);
            }
            if (Optional.IsDefined(AbatementDateTime))
            {
                writer.WritePropertyName("abatementDateTime"u8);
                writer.WriteStringValue(AbatementDateTime);
            }
            if (Optional.IsDefined(AbatementAge))
            {
                writer.WritePropertyName("abatementAge"u8);
                writer.WriteObjectValue(AbatementAge, options);
            }
            if (Optional.IsDefined(AbatementPeriod))
            {
                writer.WritePropertyName("abatementPeriod"u8);
                writer.WriteObjectValue(AbatementPeriod, options);
            }
            if (Optional.IsDefined(AbatementRange))
            {
                writer.WritePropertyName("abatementRange"u8);
                writer.WriteObjectValue(AbatementRange, options);
            }
            if (Optional.IsDefined(AbatementString))
            {
                writer.WritePropertyName("abatementString"u8);
                writer.WriteStringValue(AbatementString);
            }
            if (Optional.IsDefined(RecordedDate))
            {
                writer.WritePropertyName("recordedDate"u8);
                writer.WriteStringValue(RecordedDate);
            }
            if (Optional.IsCollectionDefined(Stage))
            {
                writer.WritePropertyName("stage"u8);
                writer.WriteStartArray();
                foreach (var item in Stage)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Note))
            {
                writer.WritePropertyName("note"u8);
                writer.WriteStartArray();
                foreach (var item in Note)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            foreach (var item in AdditionalProperties)
            {
                writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                using (JsonDocument document = JsonDocument.Parse(item.Value))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
        }

        FhirR4Condition IJsonModel<FhirR4Condition>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4Condition>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(FhirR4Condition)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeFhirR4Condition(document.RootElement, options);
        }

        internal static FhirR4Condition DeserializeFhirR4Condition(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<FhirR4Identifier> identifier = default;
            FhirR4CodeableConcept clinicalStatus = default;
            FhirR4CodeableConcept verificationStatus = default;
            IReadOnlyList<FhirR4CodeableConcept> category = default;
            FhirR4CodeableConcept severity = default;
            FhirR4CodeableConcept code = default;
            IReadOnlyList<FhirR4CodeableConcept> bodySite = default;
            FhirR4Reference encounter = default;
            string onsetDateTime = default;
            FhirR4Quantity onsetAge = default;
            FhirR4Period onsetPeriod = default;
            FhirR4Range onsetRange = default;
            string onsetString = default;
            string abatementDateTime = default;
            FhirR4Quantity abatementAge = default;
            FhirR4Period abatementPeriod = default;
            FhirR4Range abatementRange = default;
            string abatementString = default;
            string recordedDate = default;
            IReadOnlyList<FhirR4ConditionStage> stage = default;
            IReadOnlyList<FhirR4Annotation> note = default;
            FhirR4Narrative text = default;
            IReadOnlyList<FhirR4Resource> contained = default;
            IReadOnlyList<FhirR4Extension> extension = default;
            IReadOnlyList<FhirR4Extension> modifierExtension = default;
            string resourceType = default;
            string id = default;
            FhirR4Meta meta = default;
            string implicitRules = default;
            string language = default;
            IDictionary<string, BinaryData> additionalProperties = default;
            Dictionary<string, BinaryData> additionalPropertiesDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("identifier"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Identifier> array = new List<FhirR4Identifier>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Identifier.DeserializeFhirR4Identifier(item, options));
                    }
                    identifier = array;
                    continue;
                }
                if (property.NameEquals("clinicalStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    clinicalStatus = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("verificationStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    verificationStatus = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("category"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4CodeableConcept> array = new List<FhirR4CodeableConcept>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(item, options));
                    }
                    category = array;
                    continue;
                }
                if (property.NameEquals("severity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    severity = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("code"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    code = FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(property.Value, options);
                    continue;
                }
                if (property.NameEquals("bodySite"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4CodeableConcept> array = new List<FhirR4CodeableConcept>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4CodeableConcept.DeserializeFhirR4CodeableConcept(item, options));
                    }
                    bodySite = array;
                    continue;
                }
                if (property.NameEquals("encounter"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    encounter = FhirR4Reference.DeserializeFhirR4Reference(property.Value, options);
                    continue;
                }
                if (property.NameEquals("onsetDateTime"u8))
                {
                    onsetDateTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("onsetAge"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    onsetAge = FhirR4Quantity.DeserializeFhirR4Quantity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("onsetPeriod"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    onsetPeriod = FhirR4Period.DeserializeFhirR4Period(property.Value, options);
                    continue;
                }
                if (property.NameEquals("onsetRange"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    onsetRange = FhirR4Range.DeserializeFhirR4Range(property.Value, options);
                    continue;
                }
                if (property.NameEquals("onsetString"u8))
                {
                    onsetString = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("abatementDateTime"u8))
                {
                    abatementDateTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("abatementAge"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    abatementAge = FhirR4Quantity.DeserializeFhirR4Quantity(property.Value, options);
                    continue;
                }
                if (property.NameEquals("abatementPeriod"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    abatementPeriod = FhirR4Period.DeserializeFhirR4Period(property.Value, options);
                    continue;
                }
                if (property.NameEquals("abatementRange"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    abatementRange = FhirR4Range.DeserializeFhirR4Range(property.Value, options);
                    continue;
                }
                if (property.NameEquals("abatementString"u8))
                {
                    abatementString = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("recordedDate"u8))
                {
                    recordedDate = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("stage"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4ConditionStage> array = new List<FhirR4ConditionStage>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4ConditionStage.DeserializeFhirR4ConditionStage(item, options));
                    }
                    stage = array;
                    continue;
                }
                if (property.NameEquals("note"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Annotation> array = new List<FhirR4Annotation>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Annotation.DeserializeFhirR4Annotation(item, options));
                    }
                    note = array;
                    continue;
                }
                if (property.NameEquals("text"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    text = FhirR4Narrative.DeserializeFhirR4Narrative(property.Value, options);
                    continue;
                }
                if (property.NameEquals("contained"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Resource> array = new List<FhirR4Resource>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DeserializeFhirR4Resource(item, options));
                    }
                    contained = array;
                    continue;
                }
                if (property.NameEquals("extension"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Extension> array = new List<FhirR4Extension>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Extension.DeserializeFhirR4Extension(item, options));
                    }
                    extension = array;
                    continue;
                }
                if (property.NameEquals("modifierExtension"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FhirR4Extension> array = new List<FhirR4Extension>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FhirR4Extension.DeserializeFhirR4Extension(item, options));
                    }
                    modifierExtension = array;
                    continue;
                }
                if (property.NameEquals("resourceType"u8))
                {
                    resourceType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("meta"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    meta = FhirR4Meta.DeserializeFhirR4Meta(property.Value, options);
                    continue;
                }
                if (property.NameEquals("implicitRules"u8))
                {
                    implicitRules = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("language"u8))
                {
                    language = property.Value.GetString();
                    continue;
                }
                additionalPropertiesDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
            }
            additionalProperties = additionalPropertiesDictionary;
            return new FhirR4Condition(
                resourceType,
                id,
                meta,
                implicitRules,
                language,
                additionalProperties,
                text,
                contained ?? new ChangeTrackingList<FhirR4Resource>(),
                extension ?? new ChangeTrackingList<FhirR4Extension>(),
                modifierExtension ?? new ChangeTrackingList<FhirR4Extension>(),
                identifier ?? new ChangeTrackingList<FhirR4Identifier>(),
                clinicalStatus,
                verificationStatus,
                category ?? new ChangeTrackingList<FhirR4CodeableConcept>(),
                severity,
                code,
                bodySite ?? new ChangeTrackingList<FhirR4CodeableConcept>(),
                encounter,
                onsetDateTime,
                onsetAge,
                onsetPeriod,
                onsetRange,
                onsetString,
                abatementDateTime,
                abatementAge,
                abatementPeriod,
                abatementRange,
                abatementString,
                recordedDate,
                stage ?? new ChangeTrackingList<FhirR4ConditionStage>(),
                note ?? new ChangeTrackingList<FhirR4Annotation>());
        }

        BinaryData IPersistableModel<FhirR4Condition>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4Condition>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(FhirR4Condition)} does not support writing '{options.Format}' format.");
            }
        }

        FhirR4Condition IPersistableModel<FhirR4Condition>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<FhirR4Condition>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeFhirR4Condition(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(FhirR4Condition)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<FhirR4Condition>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new FhirR4Condition FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeFhirR4Condition(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal override RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
