// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Concept - reference to a terminology or just text
    /// Based on [FHIR CodeableConcept](https://www.hl7.org/fhir/R4/datatypes.html#CodeableConcept)
    /// </summary>
    public partial class FhirR4CodeableConcept : FhirR4Element
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4CodeableConcept"/>. </summary>
        public FhirR4CodeableConcept()
        {
            Coding = new ChangeTrackingList<FhirR4Coding>();
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4CodeableConcept"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="coding"> Code defined by a terminology system. </param>
        /// <param name="text"> Plain text representation of the concept. </param>
        internal FhirR4CodeableConcept(string id, IList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<FhirR4Coding> coding, string text) : base(id, extension, serializedAdditionalRawData)
        {
            Coding = coding;
            Text = text;
        }

        /// <summary> Code defined by a terminology system. </summary>
        public IList<FhirR4Coding> Coding { get; }
        /// <summary> Plain text representation of the concept. </summary>
        public string Text { get; set; }
    }
}
