// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// A text note which also  contains information about who made the statement and when
    /// Based on [FHIR Annotation](https://www.hl7.org/fhir/R4/datatypes.html#Annotation)
    /// </summary>
    public partial class FhirR4Annotation : FhirR4Element
    {
        /// <summary> Initializes a new instance of <see cref="FhirR4Annotation"/>. </summary>
        /// <param name="text"> The annotation - text content (as markdown). </param>
        /// <exception cref="ArgumentNullException"> <paramref name="text"/> is null. </exception>
        internal FhirR4Annotation(string text)
        {
            Argument.AssertNotNull(text, nameof(text));

            Text = text;
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Annotation"/>. </summary>
        /// <param name="id"> Unique id for inter-element referencing. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="authorString"> Individual responsible for the annotation. </param>
        /// <param name="time"> When the annotation was made. </param>
        /// <param name="text"> The annotation - text content (as markdown). </param>
        internal FhirR4Annotation(string id, IList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, string authorString, string time, string text) : base(id, extension, serializedAdditionalRawData)
        {
            AuthorString = authorString;
            Time = time;
            Text = text;
        }

        /// <summary> Initializes a new instance of <see cref="FhirR4Annotation"/> for deserialization. </summary>
        internal FhirR4Annotation()
        {
        }

        /// <summary> Individual responsible for the annotation. </summary>
        public string AuthorString { get; }
        /// <summary> When the annotation was made. </summary>
        public string Time { get; }
        /// <summary> The annotation - text content (as markdown). </summary>
        public string Text { get; }
    }
}
