// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Known values codes that can be used to indicate the class of encounter (TODO://Based on FHIR value set--http://....). </summary>
    public readonly partial struct EncounterClass : IEquatable<EncounterClass>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EncounterClass"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EncounterClass(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InPatientValue = "inpatient";
        private const string AmbulatoryValue = "ambulatory";
        private const string ObservationValue = "observation";
        private const string EmergencyValue = "emergency";
        private const string VirtualValue = "virtual";
        private const string HealthHomeValue = "healthHome";

        /// <summary> A patient encounter where a patient is admitted by a hospital or equivalent facility, assigned to a location where patients generally stay at least overnight and provided with room, board, and continuous nursing service. </summary>
        public static EncounterClass InPatient { get; } = new EncounterClass(InPatientValue);
        /// <summary> The term ambulatory usually implies that the patient has come to the location and is not assigned to a bed. Sometimes referred to as an outpatient encounter. </summary>
        public static EncounterClass Ambulatory { get; } = new EncounterClass(AmbulatoryValue);
        /// <summary> An encounter where the patient usually will start in different encounter, such as one in the emergency department but then transition to this type of encounter because they require a significant period of treatment and monitoring to determine whether or not their condition warrants an inpatient admission or discharge. </summary>
        public static EncounterClass Observation { get; } = new EncounterClass(ObservationValue);
        /// <summary> A patient encounter that takes place at a dedicated healthcare service delivery location where the patient receives immediate evaluation and treatment, provided until the patient can be discharged or responsibility for the patient's care is transferred elsewhere (for example, the patient could be admitted as an inpatient or transferred to another facility. </summary>
        public static EncounterClass Emergency { get; } = new EncounterClass(EmergencyValue);
        /// <summary> A patient encounter where the patient is not physically present for the encounter, such as in a telehealth encounter, phone call, or electronic communication. </summary>
        public static EncounterClass Virtual { get; } = new EncounterClass(VirtualValue);
        /// <summary> Healthcare encounter that takes place in the residence of the patient or a designee. </summary>
        public static EncounterClass HealthHome { get; } = new EncounterClass(HealthHomeValue);
        /// <summary> Determines if two <see cref="EncounterClass"/> values are the same. </summary>
        public static bool operator ==(EncounterClass left, EncounterClass right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EncounterClass"/> values are not the same. </summary>
        public static bool operator !=(EncounterClass left, EncounterClass right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EncounterClass"/>. </summary>
        public static implicit operator EncounterClass(string value) => new EncounterClass(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EncounterClass other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EncounterClass other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
