// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Document administrative metadata. </summary>
    public partial class DocumentAdministrativeMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DocumentAdministrativeMetadata"/>. </summary>
        public DocumentAdministrativeMetadata()
        {
            OrderedProcedures = new ChangeTrackingList<OrderedProcedure>();
        }

        /// <summary> Initializes a new instance of <see cref="DocumentAdministrativeMetadata"/>. </summary>
        /// <param name="orderedProcedures"> List of procedure information associated with the document. </param>
        /// <param name="encounterId"> Reference to the encounter associated with the document. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DocumentAdministrativeMetadata(IList<OrderedProcedure> orderedProcedures, string encounterId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OrderedProcedures = orderedProcedures;
            EncounterId = encounterId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of procedure information associated with the document. </summary>
        public IList<OrderedProcedure> OrderedProcedures { get; }
        /// <summary> Reference to the encounter associated with the document. </summary>
        public string EncounterId { get; set; }
    }
}
