// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> Critical results refer to findings of utmost importance that may require timely attention due to their potential impact on patient care. </summary>
    public partial class CriticalResultInference : RadiologyInsightsInference
    {
        /// <summary> Initializes a new instance of <see cref="CriticalResultInference"/>. </summary>
        /// <param name="result"> The complete Critical Result, as outlined below, will be reused for the recommendation. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="result"/> is null. </exception>
        internal CriticalResultInference(CriticalResult result)
        {
            Argument.AssertNotNull(result, nameof(result));

            Kind = RadiologyInsightsInferenceType.CriticalResult;
            Result = result;
        }

        /// <summary> Initializes a new instance of <see cref="CriticalResultInference"/>. </summary>
        /// <param name="kind"> Discriminator property for RadiologyInsightsInference. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="result"> The complete Critical Result, as outlined below, will be reused for the recommendation. </param>
        internal CriticalResultInference(RadiologyInsightsInferenceType kind, IReadOnlyList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData, CriticalResult result) : base(kind, extension, serializedAdditionalRawData)
        {
            Result = result;
        }

        /// <summary> Initializes a new instance of <see cref="CriticalResultInference"/> for deserialization. </summary>
        internal CriticalResultInference()
        {
        }

        /// <summary> The complete Critical Result, as outlined below, will be reused for the recommendation. </summary>
        public CriticalResult Result { get; }
    }
}
