// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary>
    /// Contact Point System
    /// see https://www.hl7.org/fhir/R4/valueset-contact-point-system.html
    /// </summary>
    public readonly partial struct ContactPointSystem : IEquatable<ContactPointSystem>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ContactPointSystem"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ContactPointSystem(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PhoneValue = "phone";
        private const string FaxValue = "fax";
        private const string EmailValue = "email";
        private const string PagerValue = "pager";
        private const string UrlValue = "url";
        private const string SmsValue = "sms";
        private const string OtherValue = "other";

        /// <summary> Phone. </summary>
        public static ContactPointSystem Phone { get; } = new ContactPointSystem(PhoneValue);
        /// <summary> Fax. </summary>
        public static ContactPointSystem Fax { get; } = new ContactPointSystem(FaxValue);
        /// <summary> Email. </summary>
        public static ContactPointSystem Email { get; } = new ContactPointSystem(EmailValue);
        /// <summary> Pager. </summary>
        public static ContactPointSystem Pager { get; } = new ContactPointSystem(PagerValue);
        /// <summary> Url. </summary>
        public static ContactPointSystem Url { get; } = new ContactPointSystem(UrlValue);
        /// <summary> Sms. </summary>
        public static ContactPointSystem Sms { get; } = new ContactPointSystem(SmsValue);
        /// <summary> Other. </summary>
        public static ContactPointSystem Other { get; } = new ContactPointSystem(OtherValue);
        /// <summary> Determines if two <see cref="ContactPointSystem"/> values are the same. </summary>
        public static bool operator ==(ContactPointSystem left, ContactPointSystem right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ContactPointSystem"/> values are not the same. </summary>
        public static bool operator !=(ContactPointSystem left, ContactPointSystem right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ContactPointSystem"/>. </summary>
        public static implicit operator ContactPointSystem(string value) => new ContactPointSystem(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ContactPointSystem other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ContactPointSystem other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
