// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.RadiologyInsights
{
    /// <summary> A notification for age mismatch is displayed when the age mentioned in a document for a specific patient does not match the age specified in the patient information. </summary>
    public partial class AgeMismatchInference : RadiologyInsightsInference
    {
        /// <summary> Initializes a new instance of <see cref="AgeMismatchInference"/>. </summary>
        internal AgeMismatchInference()
        {
            Kind = RadiologyInsightsInferenceType.AgeMismatch;
        }

        /// <summary> Initializes a new instance of <see cref="AgeMismatchInference"/>. </summary>
        /// <param name="kind"> Discriminator property for RadiologyInsightsInference. </param>
        /// <param name="extension"> Additional Content defined by implementations. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AgeMismatchInference(RadiologyInsightsInferenceType kind, IReadOnlyList<FhirR4Extension> extension, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(kind, extension, serializedAdditionalRawData)
        {
        }
    }
}
