---
page_type: sample
languages:
- csharp
products:
- azure
- azure-cognitive-services
- azure-health-insights
name: Azure Health Insights - Radiology Insights samples for .NET
description: Samples for the Azure.Health.Insights.RadiologyInsights client library
---

# Azure Health Insights RadiologyInsights client SDK Samples
These code samples show common scenario operations with the Azure Health Insights RadiologyInsights client library.

|**Sample Name**|**Description**|
|----------------|-------------|
|[Sample01_AgeMismatchSample][sample_get_age_mismatch_sync] |Get all Age Mismatch Inferences and show the tokens and display the document content data that triggered the age mismatch inference. (sync)|
|[Sample01_AgeMismatchSampleAsync][sample_get_age_mismatch_async] |Get all Age Mismatch Inferences and show the tokens and display the document content data that triggered the age mismatch inference. (async)|
|[Sample01_CompleteOrderDiscrepancySample][sample_get_complete_order_discrepancy_sync] |Get all Complete Order Discrepancy Inferences and show the order type, missing body parts and missing body part measurements of the complete order discrepancy inference. (sync)|
|[Sample01_CompleteOrderDiscrepancySampleAsync][sample_get_complete_order_discrepancy_async] |Get all Complete Order Discrepancy Inferences and show the order type, missing body parts and missing body part measurements of the complete order discrepancy inference. (async)|
|[Sample01_CriticalResultSample][sample_get_critical_result_sync] |Get all Critical Result Inferences and show the description. (sync)|
|[Sample01_CriticalResultSampleAsync][sample_get_critical_result_async] |Get all Critical Result Inferences and show the description. (async)|
|[Sample01_FindingSample][sample_get_finding_sample_sync] |Get all Finding Inferences and show the categories, interpretations and components of the finding inference. (sync)|
|[Sample01_FindingSampleAsync][sample_get_finding_sample_async] |Get all Finding Inferences and show the categories, interpretations and components of the finding inference. (async)|
|[Sample01_FollowupCommunicationSample][sample_get_followup_communication_sync] |Get all Followup Communication Inferences and show the datetime, recipient and acknowledgement of the followup communication inference. (sync)|
|[Sample01_FollowupCommunicationSampleAsync][sample_get_followup_communication_async] |Get all Followup Communication Inferences and show the datetime, recipient and acknowledgement of the followup communication inference. (async)|
|[Sample01_FollowupRecommendationSample][sample_get_followup_recommendation_sync] |Get all Followup Recommendation Inferences and show the generic procedure recommendation, imaging procedure recommendation of the followup recommendation inference. (sync)|
|[Sample01_FollowupRecommendationSampleAsync][sample_get_followup_recommendation_async] |Get all Followup Recommendation Inferences and show the generic procedure recommendation, imaging procedure recommendation of the followup recommendation inference. (async)|
|[Sample01_LateralityDiscrepancySample][sample_get_laterality_discrepancy_sync] |Get all Laterality Discrepancy Inferences and show the coding list of the laterality discrepancy inference and print the code, display and system properties of the codes. (sync)|
|[Sample01_LateralityDiscrepancySampleAsync][sample_get_laterality_discrepancy_async] |Get all Laterality Discrepancy Inferences and show the coding list of the laterality discrepancy inference and print the code, display and system properties of the codes. (async)|
|[Sample01_LimitedOrderSample][sample_get_limited_order_sync] |Get all Limited Order Inferences and show the order type, missing body parts and missing body part measurements of the limited order inference. (sync)|
|[Sample01_LimitedOrderSampleAsync][sample_get_limited_order_async] |Get all Limited Order Inferences and show the order type, missing body parts and missing body part measurements of the limited order inference. (async)|
|[Sample01_RadiologyProcedureSample][sample_get_radiology_procedure_sync] |Get all Radiology Procedure Inferences and show the procedure codes, imaging procedures and ordered procedure from the radiology procedure inference and print their code details. (sync)|
|[Sample01_RadiologyProcedureSampleAsync][sample_get_radiology_procedure_async] |Get all Radiology Procedure Inferences and show the procedure codes, imaging procedures and ordered procedure from the radiology procedure inference and print their code details. (async)|
|[Sample01_SexMismatchSample][sample_get_sex_mismatch_sync] |Get all Sex Mismatch Inferences and show the sex indication from the sex mismatch inference and using it print the code, display and system properties of the sex indication codes. (sync)|
|[Sample01_SexMismatchSampleAsync][sample_get_sex_mismatch_async] |Get all Sex Mismatch Inferences and show the sex indication from the sex mismatch inference and using it print the code, display and system properties of the sex indication codes. (async)|

<!-- LINKS -->
[sample_get_critical_result_sync]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_CriticalResultSample.md
[sample_get_critical_result_async]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_CriticalResultSampleAsync.md
[sample_get_age_mismatch_sync]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_AgeMismatchSample.md
[sample_get_age_mismatch_async]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_AgeMismatchSampleAsync.md
[sample_get_complete_order_discrepancy_sync]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_CompleteOrderDiscrepancySample.md
[sample_get_complete_order_discrepancy_async]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_CompleteOrderDiscrepancySampleAsync.md
[sample_get_finding_sample_sync]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_FindingSample.md
[sample_get_finding_sample_async]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_FindingSampleAsync.md
[sample_get_followup_communication_sync]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_FollowupCommunicationSample.md
[sample_get_followup_communication_async]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_FollowupCommunicationSampleAsync.md
[sample_get_followup_recommendation_sync]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_FollowupRecommendationSample.md
[sample_get_followup_recommendation_async]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_FollowupRecommendationSampleAsync.md
[sample_get_laterality_discrepancy_sync]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_LateralityDiscrepancySample.md
[sample_get_laterality_discrepancy_async]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_LateralityDiscrepancySampleAsync.md
[sample_get_limited_order_sync]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_LimitedOrderSample.md
[sample_get_limited_order_async]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_LimitedOrderSampleAsync.md
[sample_get_radiology_procedure_sync]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_RadiologyProcedureSample.md
[sample_get_radiology_procedure_async]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_RadiologyProcedureSampleAsync.md
[sample_get_sex_mismatch_sync]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_SexMismatchSample.md
[sample_get_sex_mismatch_async]: https://github.com/Azure/azure-sdk-for-net/tree/main/sdk/healthinsights/Azure.Health.Insights.RadiologyInsights/samples/Sample01_SexMismatchSampleAsync.md
