// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> Configuration affecting the Trial Matcher model's inference. </summary>
    public partial class TrialMatcherModelConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TrialMatcherModelConfiguration"/>. </summary>
        /// <param name="clinicalTrials">
        /// The clinical trials that the patient(s) should be matched to. &lt;br /&gt;The trial
        /// selection can be given as a list of custom clinical trials and/or a list of
        /// filters to known clinical trial registries. In case both are given, the
        /// resulting trial set is a union of the two sets.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clinicalTrials"/> is null. </exception>
        public TrialMatcherModelConfiguration(ClinicalTrials clinicalTrials)
        {
            Argument.AssertNotNull(clinicalTrials, nameof(clinicalTrials));

            ClinicalTrials = clinicalTrials;
        }

        /// <summary> Initializes a new instance of <see cref="TrialMatcherModelConfiguration"/>. </summary>
        /// <param name="verbose"> An indication whether the model should produce verbose output. </param>
        /// <param name="includeEvidence"> An indication whether the model's output should include evidence for the inferences. </param>
        /// <param name="clinicalTrials">
        /// The clinical trials that the patient(s) should be matched to. &lt;br /&gt;The trial
        /// selection can be given as a list of custom clinical trials and/or a list of
        /// filters to known clinical trial registries. In case both are given, the
        /// resulting trial set is a union of the two sets.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TrialMatcherModelConfiguration(bool? verbose, bool? includeEvidence, ClinicalTrials clinicalTrials, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Verbose = verbose;
            IncludeEvidence = includeEvidence;
            ClinicalTrials = clinicalTrials;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TrialMatcherModelConfiguration"/> for deserialization. </summary>
        internal TrialMatcherModelConfiguration()
        {
        }

        /// <summary> An indication whether the model should produce verbose output. </summary>
        public bool? Verbose { get; set; }
        /// <summary> An indication whether the model's output should include evidence for the inferences. </summary>
        public bool? IncludeEvidence { get; set; }
        /// <summary>
        /// The clinical trials that the patient(s) should be matched to. &lt;br /&gt;The trial
        /// selection can be given as a list of custom clinical trials and/or a list of
        /// filters to known clinical trial registries. In case both are given, the
        /// resulting trial set is a union of the two sets.
        /// </summary>
        public ClinicalTrials ClinicalTrials { get; }
    }
}
