// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> The type of the Trial Matcher inference. </summary>
    public readonly partial struct TrialMatcherInferenceType : IEquatable<TrialMatcherInferenceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TrialMatcherInferenceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TrialMatcherInferenceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TrialEligibilityValue = "trialEligibility";

        /// <summary> trialEligibility. </summary>
        public static TrialMatcherInferenceType TrialEligibility { get; } = new TrialMatcherInferenceType(TrialEligibilityValue);
        /// <summary> Determines if two <see cref="TrialMatcherInferenceType"/> values are the same. </summary>
        public static bool operator ==(TrialMatcherInferenceType left, TrialMatcherInferenceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TrialMatcherInferenceType"/> values are not the same. </summary>
        public static bool operator !=(TrialMatcherInferenceType left, TrialMatcherInferenceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TrialMatcherInferenceType"/>. </summary>
        public static implicit operator TrialMatcherInferenceType(string value) => new TrialMatcherInferenceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TrialMatcherInferenceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TrialMatcherInferenceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
