// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> An inference made by the Trial Matcher model regarding a patient. </summary>
    public partial class TrialMatcherInference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TrialMatcherInference"/>. </summary>
        /// <param name="type"> The type of the Trial Matcher inference. </param>
        /// <param name="value"> The value of the inference, as relevant for the given inference type. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        internal TrialMatcherInference(TrialMatcherInferenceType type, string value)
        {
            Argument.AssertNotNull(value, nameof(value));

            Type = type;
            Value = value;
            Evidence = new ChangeTrackingList<TrialMatcherInferenceEvidence>();
        }

        /// <summary> Initializes a new instance of <see cref="TrialMatcherInference"/>. </summary>
        /// <param name="type"> The type of the Trial Matcher inference. </param>
        /// <param name="value"> The value of the inference, as relevant for the given inference type. </param>
        /// <param name="description"> The description corresponding to the inference value. </param>
        /// <param name="confidenceScore"> Confidence score for this inference. </param>
        /// <param name="evidence"> The evidence corresponding to the inference value. </param>
        /// <param name="id"> The identifier of the clinical trial. </param>
        /// <param name="source"> Possible sources of a clinical trial. </param>
        /// <param name="metadata"> Trial data which is of interest to the potential participant. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TrialMatcherInference(TrialMatcherInferenceType type, string value, string description, float? confidenceScore, IReadOnlyList<TrialMatcherInferenceEvidence> evidence, string id, ClinicalTrialSource? source, ClinicalTrialMetadata metadata, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Type = type;
            Value = value;
            Description = description;
            ConfidenceScore = confidenceScore;
            Evidence = evidence;
            Id = id;
            Source = source;
            Metadata = metadata;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TrialMatcherInference"/> for deserialization. </summary>
        internal TrialMatcherInference()
        {
        }

        /// <summary> The type of the Trial Matcher inference. </summary>
        public TrialMatcherInferenceType Type { get; }
        /// <summary> The value of the inference, as relevant for the given inference type. </summary>
        public string Value { get; }
        /// <summary> The description corresponding to the inference value. </summary>
        public string Description { get; }
        /// <summary> Confidence score for this inference. </summary>
        public float? ConfidenceScore { get; }
        /// <summary> The evidence corresponding to the inference value. </summary>
        public IReadOnlyList<TrialMatcherInferenceEvidence> Evidence { get; }
        /// <summary> The identifier of the clinical trial. </summary>
        public string Id { get; }
        /// <summary> Possible sources of a clinical trial. </summary>
        public ClinicalTrialSource? Source { get; }
        /// <summary> Trial data which is of interest to the potential participant. </summary>
        public ClinicalTrialMetadata Metadata { get; }
    }
}
