// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> `GeoJSON` object sub-type. </summary>
    public readonly partial struct GeoJsonPropertiesSubType : IEquatable<GeoJsonPropertiesSubType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GeoJsonPropertiesSubType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GeoJsonPropertiesSubType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CircleValue = "Circle";

        /// <summary> Circle. </summary>
        public static GeoJsonPropertiesSubType Circle { get; } = new GeoJsonPropertiesSubType(CircleValue);
        /// <summary> Determines if two <see cref="GeoJsonPropertiesSubType"/> values are the same. </summary>
        public static bool operator ==(GeoJsonPropertiesSubType left, GeoJsonPropertiesSubType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GeoJsonPropertiesSubType"/> values are not the same. </summary>
        public static bool operator !=(GeoJsonPropertiesSubType left, GeoJsonPropertiesSubType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GeoJsonPropertiesSubType"/>. </summary>
        public static implicit operator GeoJsonPropertiesSubType(string value) => new GeoJsonPropertiesSubType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GeoJsonPropertiesSubType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GeoJsonPropertiesSubType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
