// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> `GeoJSON` geometry type. </summary>
    public readonly partial struct GeoJsonGeometryType : IEquatable<GeoJsonGeometryType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="GeoJsonGeometryType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public GeoJsonGeometryType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PointValue = "Point";

        /// <summary> Point. </summary>
        public static GeoJsonGeometryType Point { get; } = new GeoJsonGeometryType(PointValue);
        /// <summary> Determines if two <see cref="GeoJsonGeometryType"/> values are the same. </summary>
        public static bool operator ==(GeoJsonGeometryType left, GeoJsonGeometryType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="GeoJsonGeometryType"/> values are not the same. </summary>
        public static bool operator !=(GeoJsonGeometryType left, GeoJsonGeometryType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="GeoJsonGeometryType"/>. </summary>
        public static implicit operator GeoJsonGeometryType(string value) => new GeoJsonGeometryType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is GeoJsonGeometryType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(GeoJsonGeometryType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
