// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> The type of the patient document, such as 'note' (text document) or 'fhirBundle' (FHIR JSON document). </summary>
    public readonly partial struct DocumentType : IEquatable<DocumentType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DocumentType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DocumentType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoteValue = "note";
        private const string FhirBundleValue = "fhirBundle";
        private const string DicomValue = "dicom";
        private const string GenomicSequencingValue = "genomicSequencing";

        /// <summary> note. </summary>
        public static DocumentType Note { get; } = new DocumentType(NoteValue);
        /// <summary> fhirBundle. </summary>
        public static DocumentType FhirBundle { get; } = new DocumentType(FhirBundleValue);
        /// <summary> dicom. </summary>
        public static DocumentType Dicom { get; } = new DocumentType(DicomValue);
        /// <summary> genomicSequencing. </summary>
        public static DocumentType GenomicSequencing { get; } = new DocumentType(GenomicSequencingValue);
        /// <summary> Determines if two <see cref="DocumentType"/> values are the same. </summary>
        public static bool operator ==(DocumentType left, DocumentType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DocumentType"/> values are not the same. </summary>
        public static bool operator !=(DocumentType left, DocumentType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DocumentType"/>. </summary>
        public static implicit operator DocumentType(string value) => new DocumentType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DocumentType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DocumentType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
