// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> A person's contact details. </summary>
    public partial class ContactDetails
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContactDetails"/>. </summary>
        public ContactDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContactDetails"/>. </summary>
        /// <param name="name"> The person's name. </param>
        /// <param name="email"> The person's email. </param>
        /// <param name="phone"> A person's phone number. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContactDetails(string name, string email, string phone, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Email = email;
            Phone = phone;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The person's name. </summary>
        public string Name { get; set; }
        /// <summary> The person's email. </summary>
        public string Email { get; set; }
        /// <summary> A person's phone number. </summary>
        public string Phone { get; set; }
    }
}
