// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary>
    /// The clinical trials that the patient(s) should be matched to.
    /// The trial selection can be given as a list of custom clinical trials and/or a list of filters to known clinical trial registries.
    /// In case both are given, the resulting trial set is a union of the two sets.
    /// </summary>
    public partial class ClinicalTrials
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClinicalTrials"/>. </summary>
        public ClinicalTrials()
        {
            CustomTrials = new ChangeTrackingList<ClinicalTrialDetails>();
            RegistryFilters = new ChangeTrackingList<ClinicalTrialRegistryFilter>();
        }

        /// <summary> Initializes a new instance of <see cref="ClinicalTrials"/>. </summary>
        /// <param name="customTrials"> A list of clinical trials. </param>
        /// <param name="registryFilters">
        /// A list of filters, each one creating a selection of trials from a given
        /// clinical trial registry.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClinicalTrials(IList<ClinicalTrialDetails> customTrials, IList<ClinicalTrialRegistryFilter> registryFilters, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CustomTrials = customTrials;
            RegistryFilters = registryFilters;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> A list of clinical trials. </summary>
        public IList<ClinicalTrialDetails> CustomTrials { get; }
        /// <summary>
        /// A list of filters, each one creating a selection of trials from a given
        /// clinical trial registry.
        /// </summary>
        public IList<ClinicalTrialRegistryFilter> RegistryFilters { get; }
    }
}
