// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> Possible study types of a clinical trial. </summary>
    public readonly partial struct ClinicalTrialStudyType : IEquatable<ClinicalTrialStudyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClinicalTrialStudyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClinicalTrialStudyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InterventionalValue = "interventional";
        private const string ObservationalValue = "observational";
        private const string ExpandedAccessValue = "expandedAccess";
        private const string PatientRegistriesValue = "patientRegistries";

        /// <summary> interventional. </summary>
        public static ClinicalTrialStudyType Interventional { get; } = new ClinicalTrialStudyType(InterventionalValue);
        /// <summary> observational. </summary>
        public static ClinicalTrialStudyType Observational { get; } = new ClinicalTrialStudyType(ObservationalValue);
        /// <summary> expandedAccess. </summary>
        public static ClinicalTrialStudyType ExpandedAccess { get; } = new ClinicalTrialStudyType(ExpandedAccessValue);
        /// <summary> patientRegistries. </summary>
        public static ClinicalTrialStudyType PatientRegistries { get; } = new ClinicalTrialStudyType(PatientRegistriesValue);
        /// <summary> Determines if two <see cref="ClinicalTrialStudyType"/> values are the same. </summary>
        public static bool operator ==(ClinicalTrialStudyType left, ClinicalTrialStudyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClinicalTrialStudyType"/> values are not the same. </summary>
        public static bool operator !=(ClinicalTrialStudyType left, ClinicalTrialStudyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClinicalTrialStudyType"/>. </summary>
        public static implicit operator ClinicalTrialStudyType(string value) => new ClinicalTrialStudyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClinicalTrialStudyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClinicalTrialStudyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
