// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Health.Insights.ClinicalMatching
{
    public partial class ClinicalTrialRegistryFilter : IUtf8JsonSerializable, IJsonModel<ClinicalTrialRegistryFilter>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ClinicalTrialRegistryFilter>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ClinicalTrialRegistryFilter>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClinicalTrialRegistryFilter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClinicalTrialRegistryFilter)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(Conditions))
            {
                writer.WritePropertyName("conditions"u8);
                writer.WriteStartArray();
                foreach (var item in Conditions)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(StudyTypes))
            {
                writer.WritePropertyName("studyTypes"u8);
                writer.WriteStartArray();
                foreach (var item in StudyTypes)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(RecruitmentStatuses))
            {
                writer.WritePropertyName("recruitmentStatuses"u8);
                writer.WriteStartArray();
                foreach (var item in RecruitmentStatuses)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Sponsors))
            {
                writer.WritePropertyName("sponsors"u8);
                writer.WriteStartArray();
                foreach (var item in Sponsors)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Phases))
            {
                writer.WritePropertyName("phases"u8);
                writer.WriteStartArray();
                foreach (var item in Phases)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Purposes))
            {
                writer.WritePropertyName("purposes"u8);
                writer.WriteStartArray();
                foreach (var item in Purposes)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Ids))
            {
                writer.WritePropertyName("ids"u8);
                writer.WriteStartArray();
                foreach (var item in Ids)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Sources))
            {
                writer.WritePropertyName("sources"u8);
                writer.WriteStartArray();
                foreach (var item in Sources)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FacilityNames))
            {
                writer.WritePropertyName("facilityNames"u8);
                writer.WriteStartArray();
                foreach (var item in FacilityNames)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FacilityLocations))
            {
                writer.WritePropertyName("facilityLocations"u8);
                writer.WriteStartArray();
                foreach (var item in FacilityLocations)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(FacilityAreas))
            {
                writer.WritePropertyName("facilityAreas"u8);
                writer.WriteStartArray();
                foreach (var item in FacilityAreas)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ClinicalTrialRegistryFilter IJsonModel<ClinicalTrialRegistryFilter>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClinicalTrialRegistryFilter>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClinicalTrialRegistryFilter)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeClinicalTrialRegistryFilter(document.RootElement, options);
        }

        internal static ClinicalTrialRegistryFilter DeserializeClinicalTrialRegistryFilter(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<string> conditions = default;
            IList<ClinicalTrialStudyType> studyTypes = default;
            IList<ClinicalTrialRecruitmentStatus> recruitmentStatuses = default;
            IList<string> sponsors = default;
            IList<ClinicalTrialPhase> phases = default;
            IList<ClinicalTrialPurpose> purposes = default;
            IList<string> ids = default;
            IList<ClinicalTrialSource> sources = default;
            IList<string> facilityNames = default;
            IList<GeographicLocation> facilityLocations = default;
            IList<GeographicArea> facilityAreas = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("conditions"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    conditions = array;
                    continue;
                }
                if (property.NameEquals("studyTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ClinicalTrialStudyType> array = new List<ClinicalTrialStudyType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ClinicalTrialStudyType(item.GetString()));
                    }
                    studyTypes = array;
                    continue;
                }
                if (property.NameEquals("recruitmentStatuses"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ClinicalTrialRecruitmentStatus> array = new List<ClinicalTrialRecruitmentStatus>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ClinicalTrialRecruitmentStatus(item.GetString()));
                    }
                    recruitmentStatuses = array;
                    continue;
                }
                if (property.NameEquals("sponsors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    sponsors = array;
                    continue;
                }
                if (property.NameEquals("phases"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ClinicalTrialPhase> array = new List<ClinicalTrialPhase>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ClinicalTrialPhase(item.GetString()));
                    }
                    phases = array;
                    continue;
                }
                if (property.NameEquals("purposes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ClinicalTrialPurpose> array = new List<ClinicalTrialPurpose>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ClinicalTrialPurpose(item.GetString()));
                    }
                    purposes = array;
                    continue;
                }
                if (property.NameEquals("ids"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    ids = array;
                    continue;
                }
                if (property.NameEquals("sources"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ClinicalTrialSource> array = new List<ClinicalTrialSource>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ClinicalTrialSource(item.GetString()));
                    }
                    sources = array;
                    continue;
                }
                if (property.NameEquals("facilityNames"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    facilityNames = array;
                    continue;
                }
                if (property.NameEquals("facilityLocations"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<GeographicLocation> array = new List<GeographicLocation>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(GeographicLocation.DeserializeGeographicLocation(item, options));
                    }
                    facilityLocations = array;
                    continue;
                }
                if (property.NameEquals("facilityAreas"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<GeographicArea> array = new List<GeographicArea>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(GeographicArea.DeserializeGeographicArea(item, options));
                    }
                    facilityAreas = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ClinicalTrialRegistryFilter(
                conditions ?? new ChangeTrackingList<string>(),
                studyTypes ?? new ChangeTrackingList<ClinicalTrialStudyType>(),
                recruitmentStatuses ?? new ChangeTrackingList<ClinicalTrialRecruitmentStatus>(),
                sponsors ?? new ChangeTrackingList<string>(),
                phases ?? new ChangeTrackingList<ClinicalTrialPhase>(),
                purposes ?? new ChangeTrackingList<ClinicalTrialPurpose>(),
                ids ?? new ChangeTrackingList<string>(),
                sources ?? new ChangeTrackingList<ClinicalTrialSource>(),
                facilityNames ?? new ChangeTrackingList<string>(),
                facilityLocations ?? new ChangeTrackingList<GeographicLocation>(),
                facilityAreas ?? new ChangeTrackingList<GeographicArea>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ClinicalTrialRegistryFilter>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClinicalTrialRegistryFilter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ClinicalTrialRegistryFilter)} does not support writing '{options.Format}' format.");
            }
        }

        ClinicalTrialRegistryFilter IPersistableModel<ClinicalTrialRegistryFilter>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClinicalTrialRegistryFilter>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeClinicalTrialRegistryFilter(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ClinicalTrialRegistryFilter)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ClinicalTrialRegistryFilter>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ClinicalTrialRegistryFilter FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeClinicalTrialRegistryFilter(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
