// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> Possible recruitment status of a clinical trial. </summary>
    public readonly partial struct ClinicalTrialRecruitmentStatus : IEquatable<ClinicalTrialRecruitmentStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ClinicalTrialRecruitmentStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ClinicalTrialRecruitmentStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownStatusValue = "unknownStatus";
        private const string NotYetRecruitingValue = "notYetRecruiting";
        private const string RecruitingValue = "recruiting";
        private const string EnrollingByInvitationValue = "enrollingByInvitation";

        /// <summary> unknownStatus. </summary>
        public static ClinicalTrialRecruitmentStatus UnknownStatus { get; } = new ClinicalTrialRecruitmentStatus(UnknownStatusValue);
        /// <summary> notYetRecruiting. </summary>
        public static ClinicalTrialRecruitmentStatus NotYetRecruiting { get; } = new ClinicalTrialRecruitmentStatus(NotYetRecruitingValue);
        /// <summary> recruiting. </summary>
        public static ClinicalTrialRecruitmentStatus Recruiting { get; } = new ClinicalTrialRecruitmentStatus(RecruitingValue);
        /// <summary> enrollingByInvitation. </summary>
        public static ClinicalTrialRecruitmentStatus EnrollingByInvitation { get; } = new ClinicalTrialRecruitmentStatus(EnrollingByInvitationValue);
        /// <summary> Determines if two <see cref="ClinicalTrialRecruitmentStatus"/> values are the same. </summary>
        public static bool operator ==(ClinicalTrialRecruitmentStatus left, ClinicalTrialRecruitmentStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ClinicalTrialRecruitmentStatus"/> values are not the same. </summary>
        public static bool operator !=(ClinicalTrialRecruitmentStatus left, ClinicalTrialRecruitmentStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ClinicalTrialRecruitmentStatus"/>. </summary>
        public static implicit operator ClinicalTrialRecruitmentStatus(string value) => new ClinicalTrialRecruitmentStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ClinicalTrialRecruitmentStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ClinicalTrialRecruitmentStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
