// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> Trial data which is of interest to the potential participant. </summary>
    public partial class ClinicalTrialMetadata
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClinicalTrialMetadata"/>. </summary>
        /// <param name="conditions"> Medical conditions and their synonyms which are relevant for the clinical trial, given as strings. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="conditions"/> is null. </exception>
        public ClinicalTrialMetadata(IEnumerable<string> conditions)
        {
            Argument.AssertNotNull(conditions, nameof(conditions));

            Phases = new ChangeTrackingList<ClinicalTrialPhase>();
            Conditions = conditions.ToList();
            Sponsors = new ChangeTrackingList<string>();
            Contacts = new ChangeTrackingList<ContactDetails>();
            Facilities = new ChangeTrackingList<ClinicalTrialResearchFacility>();
        }

        /// <summary> Initializes a new instance of <see cref="ClinicalTrialMetadata"/>. </summary>
        /// <param name="phases">
        /// Phases which are relevant for the clinical trial.
        /// Each clinical trial can be in a certain phase or in multiple phases.
        /// </param>
        /// <param name="studyType"> Possible study types of a clinical trial. </param>
        /// <param name="recruitmentStatus"> Possible recruitment status of a clinical trial. </param>
        /// <param name="conditions"> Medical conditions and their synonyms which are relevant for the clinical trial, given as strings. </param>
        /// <param name="sponsors"> Sponsors/collaborators involved with the trial. </param>
        /// <param name="contacts"> Contact details of the trial administrators, for patients that want to participate in the trial. </param>
        /// <param name="facilities"> Research facilities where the clinical trial is conducted. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClinicalTrialMetadata(IList<ClinicalTrialPhase> phases, ClinicalTrialStudyType? studyType, ClinicalTrialRecruitmentStatus? recruitmentStatus, IList<string> conditions, IList<string> sponsors, IList<ContactDetails> contacts, IList<ClinicalTrialResearchFacility> facilities, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Phases = phases;
            StudyType = studyType;
            RecruitmentStatus = recruitmentStatus;
            Conditions = conditions;
            Sponsors = sponsors;
            Contacts = contacts;
            Facilities = facilities;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ClinicalTrialMetadata"/> for deserialization. </summary>
        internal ClinicalTrialMetadata()
        {
        }

        /// <summary>
        /// Phases which are relevant for the clinical trial.
        /// Each clinical trial can be in a certain phase or in multiple phases.
        /// </summary>
        public IList<ClinicalTrialPhase> Phases { get; }
        /// <summary> Possible study types of a clinical trial. </summary>
        public ClinicalTrialStudyType? StudyType { get; set; }
        /// <summary> Possible recruitment status of a clinical trial. </summary>
        public ClinicalTrialRecruitmentStatus? RecruitmentStatus { get; set; }
        /// <summary> Medical conditions and their synonyms which are relevant for the clinical trial, given as strings. </summary>
        public IList<string> Conditions { get; }
        /// <summary> Sponsors/collaborators involved with the trial. </summary>
        public IList<string> Sponsors { get; }
        /// <summary> Contact details of the trial administrators, for patients that want to participate in the trial. </summary>
        public IList<ContactDetails> Contacts { get; }
        /// <summary> Research facilities where the clinical trial is conducted. </summary>
        public IList<ClinicalTrialResearchFacility> Facilities { get; }
    }
}
