// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Health.Insights.ClinicalMatching
{
    public partial class ClinicalTrialMetadata : IUtf8JsonSerializable, IJsonModel<ClinicalTrialMetadata>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ClinicalTrialMetadata>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ClinicalTrialMetadata>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClinicalTrialMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClinicalTrialMetadata)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(Phases))
            {
                writer.WritePropertyName("phases"u8);
                writer.WriteStartArray();
                foreach (var item in Phases)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(StudyType))
            {
                writer.WritePropertyName("studyType"u8);
                writer.WriteStringValue(StudyType.Value.ToString());
            }
            if (Optional.IsDefined(RecruitmentStatus))
            {
                writer.WritePropertyName("recruitmentStatus"u8);
                writer.WriteStringValue(RecruitmentStatus.Value.ToString());
            }
            writer.WritePropertyName("conditions"u8);
            writer.WriteStartArray();
            foreach (var item in Conditions)
            {
                writer.WriteStringValue(item);
            }
            writer.WriteEndArray();
            if (Optional.IsCollectionDefined(Sponsors))
            {
                writer.WritePropertyName("sponsors"u8);
                writer.WriteStartArray();
                foreach (var item in Sponsors)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Contacts))
            {
                writer.WritePropertyName("contacts"u8);
                writer.WriteStartArray();
                foreach (var item in Contacts)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Facilities))
            {
                writer.WritePropertyName("facilities"u8);
                writer.WriteStartArray();
                foreach (var item in Facilities)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ClinicalTrialMetadata IJsonModel<ClinicalTrialMetadata>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClinicalTrialMetadata>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ClinicalTrialMetadata)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeClinicalTrialMetadata(document.RootElement, options);
        }

        internal static ClinicalTrialMetadata DeserializeClinicalTrialMetadata(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IList<ClinicalTrialPhase> phases = default;
            ClinicalTrialStudyType? studyType = default;
            ClinicalTrialRecruitmentStatus? recruitmentStatus = default;
            IList<string> conditions = default;
            IList<string> sponsors = default;
            IList<ContactDetails> contacts = default;
            IList<ClinicalTrialResearchFacility> facilities = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("phases"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ClinicalTrialPhase> array = new List<ClinicalTrialPhase>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(new ClinicalTrialPhase(item.GetString()));
                    }
                    phases = array;
                    continue;
                }
                if (property.NameEquals("studyType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    studyType = new ClinicalTrialStudyType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("recruitmentStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    recruitmentStatus = new ClinicalTrialRecruitmentStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("conditions"u8))
                {
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    conditions = array;
                    continue;
                }
                if (property.NameEquals("sponsors"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    sponsors = array;
                    continue;
                }
                if (property.NameEquals("contacts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ContactDetails> array = new List<ContactDetails>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ContactDetails.DeserializeContactDetails(item, options));
                    }
                    contacts = array;
                    continue;
                }
                if (property.NameEquals("facilities"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ClinicalTrialResearchFacility> array = new List<ClinicalTrialResearchFacility>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ClinicalTrialResearchFacility.DeserializeClinicalTrialResearchFacility(item, options));
                    }
                    facilities = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ClinicalTrialMetadata(
                phases ?? new ChangeTrackingList<ClinicalTrialPhase>(),
                studyType,
                recruitmentStatus,
                conditions,
                sponsors ?? new ChangeTrackingList<string>(),
                contacts ?? new ChangeTrackingList<ContactDetails>(),
                facilities ?? new ChangeTrackingList<ClinicalTrialResearchFacility>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ClinicalTrialMetadata>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClinicalTrialMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ClinicalTrialMetadata)} does not support writing '{options.Format}' format.");
            }
        }

        ClinicalTrialMetadata IPersistableModel<ClinicalTrialMetadata>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ClinicalTrialMetadata>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeClinicalTrialMetadata(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ClinicalTrialMetadata)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ClinicalTrialMetadata>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ClinicalTrialMetadata FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeClinicalTrialMetadata(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
