// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> `GeoJSON` object properties. </summary>
    public partial class AreaProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AreaProperties"/>. </summary>
        /// <param name="subType"> `GeoJSON` object sub-type. </param>
        /// <param name="radius"> The radius of the area's circle, in meters. </param>
        public AreaProperties(GeoJsonPropertiesSubType subType, double radius)
        {
            SubType = subType;
            Radius = radius;
        }

        /// <summary> Initializes a new instance of <see cref="AreaProperties"/>. </summary>
        /// <param name="subType"> `GeoJSON` object sub-type. </param>
        /// <param name="radius"> The radius of the area's circle, in meters. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AreaProperties(GeoJsonPropertiesSubType subType, double radius, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SubType = subType;
            Radius = radius;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AreaProperties"/> for deserialization. </summary>
        internal AreaProperties()
        {
        }

        /// <summary> `GeoJSON` object sub-type. </summary>
        public GeoJsonPropertiesSubType SubType { get; }
        /// <summary> The radius of the area's circle, in meters. </summary>
        public double Radius { get; }
    }
}
