// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> `GeoJSON` geometry, representing the area circle's center. </summary>
    public partial class AreaGeometry
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AreaGeometry"/>. </summary>
        /// <param name="type"> `GeoJSON` geometry type. </param>
        /// <param name="coordinates">
        /// Coordinates of the area circle's center, represented according to the `GeoJSON` standard.
        /// This is an array of 2 decimal numbers, longitude and latitude (precisely in this order).
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="coordinates"/> is null. </exception>
        public AreaGeometry(GeoJsonGeometryType type, IEnumerable<float> coordinates)
        {
            Argument.AssertNotNull(coordinates, nameof(coordinates));

            Type = type;
            Coordinates = coordinates.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="AreaGeometry"/>. </summary>
        /// <param name="type"> `GeoJSON` geometry type. </param>
        /// <param name="coordinates">
        /// Coordinates of the area circle's center, represented according to the `GeoJSON` standard.
        /// This is an array of 2 decimal numbers, longitude and latitude (precisely in this order).
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AreaGeometry(GeoJsonGeometryType type, IList<float> coordinates, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Type = type;
            Coordinates = coordinates;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AreaGeometry"/> for deserialization. </summary>
        internal AreaGeometry()
        {
        }

        /// <summary> `GeoJSON` geometry type. </summary>
        public GeoJsonGeometryType Type { get; }
        /// <summary>
        /// Coordinates of the area circle's center, represented according to the `GeoJSON` standard.
        /// This is an array of 2 decimal numbers, longitude and latitude (precisely in this order).
        /// </summary>
        public IList<float> Coordinates { get; }
    }
}
