// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.ClinicalMatching
{
    /// <summary> A person's age, given as a number (value) and a unit (e.g. years, months). </summary>
    public partial class AcceptedAge
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AcceptedAge"/>. </summary>
        /// <param name="unit"> Possible units for a person's age. </param>
        /// <param name="value"> The number of years/months/days that represents the person's age. </param>
        public AcceptedAge(AgeUnit unit, float value)
        {
            Unit = unit;
            Value = value;
        }

        /// <summary> Initializes a new instance of <see cref="AcceptedAge"/>. </summary>
        /// <param name="unit"> Possible units for a person's age. </param>
        /// <param name="value"> The number of years/months/days that represents the person's age. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AcceptedAge(AgeUnit unit, float value, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Unit = unit;
            Value = value;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AcceptedAge"/> for deserialization. </summary>
        internal AcceptedAge()
        {
        }

        /// <summary> Possible units for a person's age. </summary>
        public AgeUnit Unit { get; }
        /// <summary> The number of years/months/days that represents the person's age. </summary>
        public float Value { get; }
    }
}
