// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Health.Insights.CancerProfiling.Samples
{
    public partial class Samples_CancerProfilingClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CancerProfilingClient_InferCancerProfile_ShortVersion()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            CancerProfilingClient client = new CancerProfilingClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                patients = new object[]
            {
new
{
id = "<id>",
}
            },
            });
            Operation<BinaryData> operation = client.InferCancerProfile(WaitUntil.Completed, content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CancerProfilingClient_InferCancerProfile_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            CancerProfilingClient client = new CancerProfilingClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                patients = new object[]
            {
new
{
id = "<id>",
}
            },
            });
            Operation<BinaryData> operation = await client.InferCancerProfileAsync(WaitUntil.Completed, content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CancerProfilingClient_InferCancerProfile_ShortVersion_Convenience()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            CancerProfilingClient client = new CancerProfilingClient(endpoint, credential);

            OncoPhenotypeData body = new OncoPhenotypeData(new PatientRecord[]
            {
new PatientRecord("<id>")
            });
            Operation<OncoPhenotypeResults> operation = client.InferCancerProfile(WaitUntil.Completed, body);
            OncoPhenotypeResults responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CancerProfilingClient_InferCancerProfile_ShortVersion_Convenience_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            CancerProfilingClient client = new CancerProfilingClient(endpoint, credential);

            OncoPhenotypeData body = new OncoPhenotypeData(new PatientRecord[]
            {
new PatientRecord("<id>")
            });
            Operation<OncoPhenotypeResults> operation = await client.InferCancerProfileAsync(WaitUntil.Completed, body);
            OncoPhenotypeResults responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CancerProfilingClient_InferCancerProfile_AllParameters()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            CancerProfilingClient client = new CancerProfilingClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                patients = new object[]
            {
new
{
id = "<id>",
info = new
{
sex = "female",
birthDate = "2022-05-10",
clinicalInfo = new object[]
{
new
{
system = "<system>",
code = "<code>",
name = "<name>",
value = "<value>",
}
},
},
data = new object[]
{
new
{
type = "note",
clinicalType = "consultation",
id = "<id>",
language = "<language>",
createdDateTime = "2022-05-10T18:57:31.2311892Z",
content = new
{
sourceType = "inline",
value = "<value>",
},
}
},
}
            },
                configuration = new
                {
                    verbose = true,
                    includeEvidence = true,
                    inferenceTypes = new object[]
            {
"tumorSite"
            },
                    checkForCancerCase = true,
                },
            });
            Operation<BinaryData> operation = client.InferCancerProfile(WaitUntil.Completed, content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("confidenceScore").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientDataEvidence").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientDataEvidence").GetProperty("text").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientDataEvidence").GetProperty("offset").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientDataEvidence").GetProperty("length").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientInfoEvidence").GetProperty("system").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientInfoEvidence").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientInfoEvidence").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientInfoEvidence").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("importance").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("caseId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CancerProfilingClient_InferCancerProfile_AllParameters_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            CancerProfilingClient client = new CancerProfilingClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                patients = new object[]
            {
new
{
id = "<id>",
info = new
{
sex = "female",
birthDate = "2022-05-10",
clinicalInfo = new object[]
{
new
{
system = "<system>",
code = "<code>",
name = "<name>",
value = "<value>",
}
},
},
data = new object[]
{
new
{
type = "note",
clinicalType = "consultation",
id = "<id>",
language = "<language>",
createdDateTime = "2022-05-10T18:57:31.2311892Z",
content = new
{
sourceType = "inline",
value = "<value>",
},
}
},
}
            },
                configuration = new
                {
                    verbose = true,
                    includeEvidence = true,
                    inferenceTypes = new object[]
            {
"tumorSite"
            },
                    checkForCancerCase = true,
                },
            });
            Operation<BinaryData> operation = await client.InferCancerProfileAsync(WaitUntil.Completed, content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("description").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("confidenceScore").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientDataEvidence").GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientDataEvidence").GetProperty("text").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientDataEvidence").GetProperty("offset").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientDataEvidence").GetProperty("length").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientInfoEvidence").GetProperty("system").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientInfoEvidence").GetProperty("code").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientInfoEvidence").GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("patientInfoEvidence").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("evidence")[0].GetProperty("importance").ToString());
            Console.WriteLine(result.GetProperty("patients")[0].GetProperty("inferences")[0].GetProperty("caseId").ToString());
            Console.WriteLine(result.GetProperty("modelVersion").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CancerProfilingClient_InferCancerProfile_AllParameters_Convenience()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            CancerProfilingClient client = new CancerProfilingClient(endpoint, credential);

            OncoPhenotypeData body = new OncoPhenotypeData(new PatientRecord[]
            {
new PatientRecord("<id>")
{
Info = new PatientInfo
{
Sex = PatientInfoSex.Female,
BirthDate = DateTimeOffset.Parse("2022-05-10"),
ClinicalInfo = {new ClinicalCodedElement("<system>", "<code>")
{
Name = "<name>",
Value = "<value>",
}},
},
Data = {new PatientDocument(DocumentType.Note, "<id>", new DocumentContent(DocumentContentSourceType.Inline, "<value>"))
{
ClinicalType = ClinicalDocumentType.Consultation,
Language = "<language>",
CreatedDateTime = DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"),
}},
}
            })
            {
                Configuration = new OncoPhenotypeModelConfiguration
                {
                    Verbose = true,
                    IncludeEvidence = true,
                    InferenceTypes = { OncoPhenotypeInferenceType.TumorSite },
                    CheckForCancerCase = true,
                },
            };
            Operation<OncoPhenotypeResults> operation = client.InferCancerProfile(WaitUntil.Completed, body);
            OncoPhenotypeResults responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CancerProfilingClient_InferCancerProfile_AllParameters_Convenience_Async()
        {
            Uri endpoint = new Uri("<https://my-service.azure.com>");
            AzureKeyCredential credential = new AzureKeyCredential("<key>");
            CancerProfilingClient client = new CancerProfilingClient(endpoint, credential);

            OncoPhenotypeData body = new OncoPhenotypeData(new PatientRecord[]
            {
new PatientRecord("<id>")
{
Info = new PatientInfo
{
Sex = PatientInfoSex.Female,
BirthDate = DateTimeOffset.Parse("2022-05-10"),
ClinicalInfo = {new ClinicalCodedElement("<system>", "<code>")
{
Name = "<name>",
Value = "<value>",
}},
},
Data = {new PatientDocument(DocumentType.Note, "<id>", new DocumentContent(DocumentContentSourceType.Inline, "<value>"))
{
ClinicalType = ClinicalDocumentType.Consultation,
Language = "<language>",
CreatedDateTime = DateTimeOffset.Parse("2022-05-10T18:57:31.2311892Z"),
}},
}
            })
            {
                Configuration = new OncoPhenotypeModelConfiguration
                {
                    Verbose = true,
                    IncludeEvidence = true,
                    InferenceTypes = { OncoPhenotypeInferenceType.TumorSite },
                    CheckForCancerCase = true,
                },
            };
            Operation<OncoPhenotypeResults> operation = await client.InferCancerProfileAsync(WaitUntil.Completed, body);
            OncoPhenotypeResults responseData = operation.Value;
        }
    }
}
