// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Health.Insights.CancerProfiling
{
    /// <summary> The patient's sex. </summary>
    public readonly partial struct PatientInfoSex : IEquatable<PatientInfoSex>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PatientInfoSex"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PatientInfoSex(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string FemaleValue = "female";
        private const string MaleValue = "male";
        private const string UnspecifiedValue = "unspecified";

        /// <summary> female. </summary>
        public static PatientInfoSex Female { get; } = new PatientInfoSex(FemaleValue);
        /// <summary> male. </summary>
        public static PatientInfoSex Male { get; } = new PatientInfoSex(MaleValue);
        /// <summary> unspecified. </summary>
        public static PatientInfoSex Unspecified { get; } = new PatientInfoSex(UnspecifiedValue);
        /// <summary> Determines if two <see cref="PatientInfoSex"/> values are the same. </summary>
        public static bool operator ==(PatientInfoSex left, PatientInfoSex right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PatientInfoSex"/> values are not the same. </summary>
        public static bool operator !=(PatientInfoSex left, PatientInfoSex right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PatientInfoSex"/>. </summary>
        public static implicit operator PatientInfoSex(string value) => new PatientInfoSex(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PatientInfoSex other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PatientInfoSex other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
