// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Insights.CancerProfiling
{
    /// <summary> Configuration affecting the Onco Phenotype model's inference. </summary>
    public partial class OncoPhenotypeModelConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="OncoPhenotypeModelConfiguration"/>. </summary>
        public OncoPhenotypeModelConfiguration()
        {
            InferenceTypes = new ChangeTrackingList<OncoPhenotypeInferenceType>();
        }

        /// <summary> Initializes a new instance of <see cref="OncoPhenotypeModelConfiguration"/>. </summary>
        /// <param name="verbose"> An indication whether the model should produce verbose output. </param>
        /// <param name="includeEvidence"> An indication whether the model's output should include evidence for the inferences. </param>
        /// <param name="inferenceTypes">
        /// A list of inference types to be inferred for the current request.
        /// This could be used if only part of the Onco Phenotype inferences are required.
        /// If this list is omitted or empty, the model will return all the inference types.
        /// </param>
        /// <param name="checkForCancerCase"> An indication whether to perform a preliminary step on the patient's documents to determine whether they relate to a Cancer case. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal OncoPhenotypeModelConfiguration(bool? verbose, bool? includeEvidence, IList<OncoPhenotypeInferenceType> inferenceTypes, bool? checkForCancerCase, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Verbose = verbose;
            IncludeEvidence = includeEvidence;
            InferenceTypes = inferenceTypes;
            CheckForCancerCase = checkForCancerCase;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> An indication whether the model should produce verbose output. </summary>
        public bool? Verbose { get; set; }
        /// <summary> An indication whether the model's output should include evidence for the inferences. </summary>
        public bool? IncludeEvidence { get; set; }
        /// <summary>
        /// A list of inference types to be inferred for the current request.
        /// This could be used if only part of the Onco Phenotype inferences are required.
        /// If this list is omitted or empty, the model will return all the inference types.
        /// </summary>
        public IList<OncoPhenotypeInferenceType> InferenceTypes { get; }
        /// <summary> An indication whether to perform a preliminary step on the patient's documents to determine whether they relate to a Cancer case. </summary>
        public bool? CheckForCancerCase { get; set; }
    }
}
