// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure;
using Azure.Core.Extensions;
using Azure.Health.Insights.CancerProfiling;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="CancerProfilingClient"/> to client builder. </summary>
    public static partial class HealthInsightsCancerProfilingClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="CancerProfilingClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> Supported Cognitive Services endpoints (protocol and hostname, for example: https://westus2.api.cognitive.microsoft.com). </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        public static IAzureClientBuilder<CancerProfilingClient, CancerProfilingClientOptions> AddCancerProfilingClient<TBuilder>(this TBuilder builder, Uri endpoint, AzureKeyCredential credential)
        where TBuilder : IAzureClientFactoryBuilder
        {
            return builder.RegisterClientFactory<CancerProfilingClient, CancerProfilingClientOptions>((options) => new CancerProfilingClient(endpoint, credential, options));
        }

        /// <summary> Registers a <see cref="CancerProfilingClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<CancerProfilingClient, CancerProfilingClientOptions> AddCancerProfilingClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<CancerProfilingClient, CancerProfilingClientOptions>(configuration);
        }
    }
}
