// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HealthDataAIServices.Models
{
    /// <summary> The status of the current operation. </summary>
    public readonly partial struct HealthDataAIServicesProvisioningState : IEquatable<HealthDataAIServicesProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthDataAIServicesProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthDataAIServicesProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";
        private const string ProvisioningValue = "Provisioning";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string AcceptedValue = "Accepted";

        /// <summary> Resource has been created. </summary>
        public static HealthDataAIServicesProvisioningState Succeeded { get; } = new HealthDataAIServicesProvisioningState(SucceededValue);
        /// <summary> Resource creation failed. </summary>
        public static HealthDataAIServicesProvisioningState Failed { get; } = new HealthDataAIServicesProvisioningState(FailedValue);
        /// <summary> Resource creation was canceled. </summary>
        public static HealthDataAIServicesProvisioningState Canceled { get; } = new HealthDataAIServicesProvisioningState(CanceledValue);
        /// <summary> The resource is being provisioned. </summary>
        public static HealthDataAIServicesProvisioningState Provisioning { get; } = new HealthDataAIServicesProvisioningState(ProvisioningValue);
        /// <summary> The resource is being updated. </summary>
        public static HealthDataAIServicesProvisioningState Updating { get; } = new HealthDataAIServicesProvisioningState(UpdatingValue);
        /// <summary> The resource is being deleted. </summary>
        public static HealthDataAIServicesProvisioningState Deleting { get; } = new HealthDataAIServicesProvisioningState(DeletingValue);
        /// <summary> The resource provisioning request has been accepted. </summary>
        public static HealthDataAIServicesProvisioningState Accepted { get; } = new HealthDataAIServicesProvisioningState(AcceptedValue);
        /// <summary> Determines if two <see cref="HealthDataAIServicesProvisioningState"/> values are the same. </summary>
        public static bool operator ==(HealthDataAIServicesProvisioningState left, HealthDataAIServicesProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthDataAIServicesProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(HealthDataAIServicesProvisioningState left, HealthDataAIServicesProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthDataAIServicesProvisioningState"/>. </summary>
        public static implicit operator HealthDataAIServicesProvisioningState(string value) => new HealthDataAIServicesProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthDataAIServicesProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthDataAIServicesProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
