// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HealthDataAIServices.Models
{
    /// <summary> The private endpoint connection status. </summary>
    public readonly partial struct HealthDataAIServicesPrivateEndpointServiceConnectionStatus : IEquatable<HealthDataAIServicesPrivateEndpointServiceConnectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthDataAIServicesPrivateEndpointServiceConnectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthDataAIServicesPrivateEndpointServiceConnectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PendingValue = "Pending";
        private const string ApprovedValue = "Approved";
        private const string RejectedValue = "Rejected";

        /// <summary> Connectionaiting for approval or rejection. </summary>
        public static HealthDataAIServicesPrivateEndpointServiceConnectionStatus Pending { get; } = new HealthDataAIServicesPrivateEndpointServiceConnectionStatus(PendingValue);
        /// <summary> Connection approved. </summary>
        public static HealthDataAIServicesPrivateEndpointServiceConnectionStatus Approved { get; } = new HealthDataAIServicesPrivateEndpointServiceConnectionStatus(ApprovedValue);
        /// <summary> Connection Rejected. </summary>
        public static HealthDataAIServicesPrivateEndpointServiceConnectionStatus Rejected { get; } = new HealthDataAIServicesPrivateEndpointServiceConnectionStatus(RejectedValue);
        /// <summary> Determines if two <see cref="HealthDataAIServicesPrivateEndpointServiceConnectionStatus"/> values are the same. </summary>
        public static bool operator ==(HealthDataAIServicesPrivateEndpointServiceConnectionStatus left, HealthDataAIServicesPrivateEndpointServiceConnectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthDataAIServicesPrivateEndpointServiceConnectionStatus"/> values are not the same. </summary>
        public static bool operator !=(HealthDataAIServicesPrivateEndpointServiceConnectionStatus left, HealthDataAIServicesPrivateEndpointServiceConnectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthDataAIServicesPrivateEndpointServiceConnectionStatus"/>. </summary>
        public static implicit operator HealthDataAIServicesPrivateEndpointServiceConnectionStatus(string value) => new HealthDataAIServicesPrivateEndpointServiceConnectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthDataAIServicesPrivateEndpointServiceConnectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthDataAIServicesPrivateEndpointServiceConnectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
