// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.HealthDataAIServices.Models
{
    /// <summary> The current provisioning state. </summary>
    public readonly partial struct HealthDataAIServicesPrivateEndpointConnectionProvisioningState : IEquatable<HealthDataAIServicesPrivateEndpointConnectionProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HealthDataAIServicesPrivateEndpointConnectionProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HealthDataAIServicesPrivateEndpointConnectionProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string CreatingValue = "Creating";
        private const string DeletingValue = "Deleting";
        private const string FailedValue = "Failed";

        /// <summary> Connection has been provisioned. </summary>
        public static HealthDataAIServicesPrivateEndpointConnectionProvisioningState Succeeded { get; } = new HealthDataAIServicesPrivateEndpointConnectionProvisioningState(SucceededValue);
        /// <summary> Connection is being created. </summary>
        public static HealthDataAIServicesPrivateEndpointConnectionProvisioningState Creating { get; } = new HealthDataAIServicesPrivateEndpointConnectionProvisioningState(CreatingValue);
        /// <summary> Connection is being deleted. </summary>
        public static HealthDataAIServicesPrivateEndpointConnectionProvisioningState Deleting { get; } = new HealthDataAIServicesPrivateEndpointConnectionProvisioningState(DeletingValue);
        /// <summary> Connection provisioning has failed. </summary>
        public static HealthDataAIServicesPrivateEndpointConnectionProvisioningState Failed { get; } = new HealthDataAIServicesPrivateEndpointConnectionProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="HealthDataAIServicesPrivateEndpointConnectionProvisioningState"/> values are the same. </summary>
        public static bool operator ==(HealthDataAIServicesPrivateEndpointConnectionProvisioningState left, HealthDataAIServicesPrivateEndpointConnectionProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HealthDataAIServicesPrivateEndpointConnectionProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(HealthDataAIServicesPrivateEndpointConnectionProvisioningState left, HealthDataAIServicesPrivateEndpointConnectionProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HealthDataAIServicesPrivateEndpointConnectionProvisioningState"/>. </summary>
        public static implicit operator HealthDataAIServicesPrivateEndpointConnectionProvisioningState(string value) => new HealthDataAIServicesPrivateEndpointConnectionProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HealthDataAIServicesPrivateEndpointConnectionProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HealthDataAIServicesPrivateEndpointConnectionProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
