// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HealthDataAIServices
{
    internal class HealthDataAIServicesPrivateEndpointConnectionResourceOperationSource : IOperationSource<HealthDataAIServicesPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal HealthDataAIServicesPrivateEndpointConnectionResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        HealthDataAIServicesPrivateEndpointConnectionResource IOperationSource<HealthDataAIServicesPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = HealthDataAIServicesPrivateEndpointConnectionResourceData.DeserializeHealthDataAIServicesPrivateEndpointConnectionResourceData(document.RootElement);
            return new HealthDataAIServicesPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<HealthDataAIServicesPrivateEndpointConnectionResource> IOperationSource<HealthDataAIServicesPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = HealthDataAIServicesPrivateEndpointConnectionResourceData.DeserializeHealthDataAIServicesPrivateEndpointConnectionResourceData(document.RootElement);
            return new HealthDataAIServicesPrivateEndpointConnectionResource(_client, data);
        }
    }
}
