// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.HealthDataAIServices
{
    internal class DeidServiceOperationSource : IOperationSource<DeidServiceResource>
    {
        private readonly ArmClient _client;

        internal DeidServiceOperationSource(ArmClient client)
        {
            _client = client;
        }

        DeidServiceResource IOperationSource<DeidServiceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DeidServiceData.DeserializeDeidServiceData(document.RootElement);
            return new DeidServiceResource(_client, data);
        }

        async ValueTask<DeidServiceResource> IOperationSource<DeidServiceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DeidServiceData.DeserializeDeidServiceData(document.RootElement);
            return new DeidServiceResource(_client, data);
        }
    }
}
