// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Health.Deidentification.Samples
{
    public partial class Samples_DeidentificationClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidentificationJob_GetJob_GetADeIdentificationJob()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            Response response = client.GetJob("documents_smith_1", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedAt").ToString());
            Console.WriteLine(result.GetProperty("createdAt").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidentificationJob_GetJob_GetADeIdentificationJob_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            Response response = await client.GetJobAsync("documents_smith_1", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedAt").ToString());
            Console.WriteLine(result.GetProperty("createdAt").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidentificationJob_GetJob_GetADeIdentificationJob_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            Response<DeidentificationJob> response = client.GetJob("documents_smith_1");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidentificationJob_GetJob_GetADeIdentificationJob_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            Response<DeidentificationJob> response = await client.GetJobAsync("documents_smith_1");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidServices_CancelJob_CancelADeIdentificationJob()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            Response response = client.CancelJob("documents_smith_1", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedAt").ToString());
            Console.WriteLine(result.GetProperty("createdAt").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidServices_CancelJob_CancelADeIdentificationJob_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            Response response = await client.CancelJobAsync("documents_smith_1", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedAt").ToString());
            Console.WriteLine(result.GetProperty("createdAt").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidServices_CancelJob_CancelADeIdentificationJob_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            Response<DeidentificationJob> response = client.CancelJob("documents_smith_1");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidServices_CancelJob_CancelADeIdentificationJob_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            Response<DeidentificationJob> response = await client.CancelJobAsync("documents_smith_1");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidentificationJob_DeleteJob_DeleteADeIdentificationJob()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            Response response = client.DeleteJob("documents_smith_1");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidentificationJob_DeleteJob_DeleteADeIdentificationJob_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            Response response = await client.DeleteJobAsync("documents_smith_1");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidServices_Deidentify_DeIdentifyText()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                inputText = "Hello my name is John Smith.",
                operation = "Redact",
                dataType = "Plaintext",
                redactionFormat = "[{type}]",
            });
            Response response = client.Deidentify(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidServices_Deidentify_DeIdentifyText_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                inputText = "Hello my name is John Smith.",
                operation = "Redact",
                dataType = "Plaintext",
                redactionFormat = "[{type}]",
            });
            Response response = await client.DeidentifyAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidServices_Deidentify_DeIdentifyText_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            DeidentificationContent body = new DeidentificationContent("Hello my name is John Smith.")
            {
                Operation = OperationType.Redact,
                DataType = DocumentDataType.Plaintext,
                RedactionFormat = "[{type}]",
            };
            Response<DeidentificationResult> response = client.Deidentify(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidServices_Deidentify_DeIdentifyText_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            DeidentificationContent body = new DeidentificationContent("Hello my name is John Smith.")
            {
                Operation = OperationType.Redact,
                DataType = DocumentDataType.Plaintext,
                RedactionFormat = "[{type}]",
            };
            Response<DeidentificationResult> response = await client.DeidentifyAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidentificationJob_GetJobs_ListDeIdentificationJobs()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            foreach (BinaryData item in client.GetJobs(10, "K1JJRDpzOEtaQWZabUQrQUNBQUFBQUFBQUFBQT09I1JUOjEjVFJDOjEwI0ZQQzpBZ0VBQUFBTUFDUUFBQUFBQUE9PQ==", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("location").ToString());
                Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("prefix").ToString());
                Console.WriteLine(result.GetProperty("targetLocation").GetProperty("location").ToString());
                Console.WriteLine(result.GetProperty("targetLocation").GetProperty("prefix").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("lastUpdatedAt").ToString());
                Console.WriteLine(result.GetProperty("createdAt").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidentificationJob_GetJobs_ListDeIdentificationJobs_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            await foreach (BinaryData item in client.GetJobsAsync(10, "K1JJRDpzOEtaQWZabUQrQUNBQUFBQUFBQUFBQT09I1JUOjEjVFJDOjEwI0ZQQzpBZ0VBQUFBTUFDUUFBQUFBQUE9PQ==", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("location").ToString());
                Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("prefix").ToString());
                Console.WriteLine(result.GetProperty("targetLocation").GetProperty("location").ToString());
                Console.WriteLine(result.GetProperty("targetLocation").GetProperty("prefix").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("lastUpdatedAt").ToString());
                Console.WriteLine(result.GetProperty("createdAt").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidentificationJob_GetJobs_ListDeIdentificationJobs_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            foreach (DeidentificationJob item in client.GetJobs())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidentificationJob_GetJobs_ListDeIdentificationJobs_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            await foreach (DeidentificationJob item in client.GetJobsAsync())
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentDetails_GetJobDocuments_ListProcessedDocumentsWithinAJob()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            foreach (BinaryData item in client.GetJobDocuments("documents_smith_1", 10, "K1JJRDpzOEtaQWZabUQrQUNBQUFBQUFBQUFBQT09I1JUOjEjVFJDOjEwI0ZQQzpBZ0VBQUFBTUFDUUFBQUFBQUE9PQ==", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("input").GetProperty("path").ToString());
                Console.WriteLine(result.GetProperty("input").GetProperty("etag").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentDetails_GetJobDocuments_ListProcessedDocumentsWithinAJob_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            await foreach (BinaryData item in client.GetJobDocumentsAsync("documents_smith_1", 10, "K1JJRDpzOEtaQWZabUQrQUNBQUFBQUFBQUFBQT09I1JUOjEjVFJDOjEwI0ZQQzpBZ0VBQUFBTUFDUUFBQUFBQUE9PQ==", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("input").GetProperty("path").ToString());
                Console.WriteLine(result.GetProperty("input").GetProperty("etag").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DocumentDetails_GetJobDocuments_ListProcessedDocumentsWithinAJob_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            foreach (DocumentDetails item in client.GetJobDocuments("documents_smith_1"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DocumentDetails_GetJobDocuments_ListProcessedDocumentsWithinAJob_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            await foreach (DocumentDetails item in client.GetJobDocumentsAsync("documents_smith_1"))
            {
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidentificationJob_CreateJob_CreateADeIdentificationJob()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                sourceLocation = new
                {
                    location = "https://blobtest.blob.core.windows.net/container?sp=r&st=2024-01-24T18:11:10Z&se=2024-01-25T02:11:10Z&spr=https&sv=2022-11-02&sr=c&sig=signature%3D",
                    prefix = "/documents",
                    extensions = new object[]
            {
"*"
            },
                },
                targetLocation = new
                {
                    location = "https://blobtest.blob.core.windows.net/container?sp=r&st=2024-01-24T18:11:10Z&se=2024-01-25T02:11:10Z&spr=https&sv=2022-11-02&sr=c&sig=signature%3D",
                    prefix = "/documents",
                },
                operation = "Redact",
                dataType = "Plaintext",
                redactionFormat = "[{type}]",
                status = "NotStarted",
            });
            Operation<BinaryData> operation = client.CreateJob(WaitUntil.Completed, "documents_smith_1", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedAt").ToString());
            Console.WriteLine(result.GetProperty("createdAt").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidentificationJob_CreateJob_CreateADeIdentificationJob_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                sourceLocation = new
                {
                    location = "https://blobtest.blob.core.windows.net/container?sp=r&st=2024-01-24T18:11:10Z&se=2024-01-25T02:11:10Z&spr=https&sv=2022-11-02&sr=c&sig=signature%3D",
                    prefix = "/documents",
                    extensions = new object[]
            {
"*"
            },
                },
                targetLocation = new
                {
                    location = "https://blobtest.blob.core.windows.net/container?sp=r&st=2024-01-24T18:11:10Z&se=2024-01-25T02:11:10Z&spr=https&sv=2022-11-02&sr=c&sig=signature%3D",
                    prefix = "/documents",
                },
                operation = "Redact",
                dataType = "Plaintext",
                redactionFormat = "[{type}]",
                status = "NotStarted",
            });
            Operation<BinaryData> operation = await client.CreateJobAsync(WaitUntil.Completed, "documents_smith_1", content);
            BinaryData responseData = operation.Value;

            JsonElement result = JsonDocument.Parse(responseData.ToStream()).RootElement;
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("sourceLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("location").ToString());
            Console.WriteLine(result.GetProperty("targetLocation").GetProperty("prefix").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("lastUpdatedAt").ToString());
            Console.WriteLine(result.GetProperty("createdAt").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeidentificationJob_CreateJob_CreateADeIdentificationJob_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            DeidentificationJob resource = new DeidentificationJob(new SourceStorageLocation(new Uri("https://blobtest.blob.core.windows.net/container?sp=r&st=2024-01-24T18:11:10Z&se=2024-01-25T02:11:10Z&spr=https&sv=2022-11-02&sr=c&sig=signature%3D"), "/documents")
            {
                Extensions = { "*" },
            }, new TargetStorageLocation(new Uri("https://blobtest.blob.core.windows.net/container?sp=r&st=2024-01-24T18:11:10Z&se=2024-01-25T02:11:10Z&spr=https&sv=2022-11-02&sr=c&sig=signature%3D"), "/documents"))
            {
                Operation = OperationType.Redact,
                DataType = DocumentDataType.Plaintext,
                RedactionFormat = "[{type}]",
            };
            Operation<DeidentificationJob> operation = client.CreateJob(WaitUntil.Completed, "documents_smith_1", resource);
            DeidentificationJob responseData = operation.Value;
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeidentificationJob_CreateJob_CreateADeIdentificationJob_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            DeidentificationClient client = new DeidentificationClient(endpoint, credential);

            DeidentificationJob resource = new DeidentificationJob(new SourceStorageLocation(new Uri("https://blobtest.blob.core.windows.net/container?sp=r&st=2024-01-24T18:11:10Z&se=2024-01-25T02:11:10Z&spr=https&sv=2022-11-02&sr=c&sig=signature%3D"), "/documents")
            {
                Extensions = { "*" },
            }, new TargetStorageLocation(new Uri("https://blobtest.blob.core.windows.net/container?sp=r&st=2024-01-24T18:11:10Z&se=2024-01-25T02:11:10Z&spr=https&sv=2022-11-02&sr=c&sig=signature%3D"), "/documents"))
            {
                Operation = OperationType.Redact,
                DataType = DocumentDataType.Plaintext,
                RedactionFormat = "[{type}]",
            };
            Operation<DeidentificationJob> operation = await client.CreateJobAsync(WaitUntil.Completed, "documents_smith_1", resource);
            DeidentificationJob responseData = operation.Value;
        }
    }
}
