// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Deidentification
{
    /// <summary> Storage location. </summary>
    public partial class TargetStorageLocation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TargetStorageLocation"/>. </summary>
        /// <param name="location"> URL to storage location. </param>
        /// <param name="prefix"> Prefix to filter path by. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="location"/> or <paramref name="prefix"/> is null. </exception>
        public TargetStorageLocation(Uri location, string prefix)
        {
            Argument.AssertNotNull(location, nameof(location));
            Argument.AssertNotNull(prefix, nameof(prefix));

            Location = location;
            Prefix = prefix;
        }

        /// <summary> Initializes a new instance of <see cref="TargetStorageLocation"/>. </summary>
        /// <param name="location"> URL to storage location. </param>
        /// <param name="prefix"> Prefix to filter path by. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TargetStorageLocation(Uri location, string prefix, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Location = location;
            Prefix = prefix;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TargetStorageLocation"/> for deserialization. </summary>
        internal TargetStorageLocation()
        {
        }

        /// <summary> URL to storage location. </summary>
        public Uri Location { get; set; }
        /// <summary> Prefix to filter path by. </summary>
        public string Prefix { get; set; }
    }
}
