// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Deidentification
{
    /// <summary> Summary metrics of a job. </summary>
    public partial class JobSummary
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="JobSummary"/>. </summary>
        /// <param name="successful"> Number of documents that have completed. </param>
        /// <param name="failed"> Number of documents that have failed. </param>
        /// <param name="canceled"> Number of documents that have been canceled. </param>
        /// <param name="total"> Number of documents total. </param>
        /// <param name="bytesProcessed"> Number of bytes processed. </param>
        internal JobSummary(int successful, int failed, int canceled, int total, long bytesProcessed)
        {
            Successful = successful;
            Failed = failed;
            Canceled = canceled;
            Total = total;
            BytesProcessed = bytesProcessed;
        }

        /// <summary> Initializes a new instance of <see cref="JobSummary"/>. </summary>
        /// <param name="successful"> Number of documents that have completed. </param>
        /// <param name="failed"> Number of documents that have failed. </param>
        /// <param name="canceled"> Number of documents that have been canceled. </param>
        /// <param name="total"> Number of documents total. </param>
        /// <param name="bytesProcessed"> Number of bytes processed. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal JobSummary(int successful, int failed, int canceled, int total, long bytesProcessed, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Successful = successful;
            Failed = failed;
            Canceled = canceled;
            Total = total;
            BytesProcessed = bytesProcessed;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="JobSummary"/> for deserialization. </summary>
        internal JobSummary()
        {
        }

        /// <summary> Number of documents that have completed. </summary>
        public int Successful { get; }
        /// <summary> Number of documents that have failed. </summary>
        public int Failed { get; }
        /// <summary> Number of documents that have been canceled. </summary>
        public int Canceled { get; }
        /// <summary> Number of documents total. </summary>
        public int Total { get; }
        /// <summary> Number of bytes processed. </summary>
        public long BytesProcessed { get; }
    }
}
