// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Deidentification
{
    /// <summary> Location of a document. </summary>
    public partial class DocumentLocation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DocumentLocation"/>. </summary>
        /// <param name="path"> Path of document in storage. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="path"/> is null. </exception>
        internal DocumentLocation(string path)
        {
            Argument.AssertNotNull(path, nameof(path));

            Path = path;
        }

        /// <summary> Initializes a new instance of <see cref="DocumentLocation"/>. </summary>
        /// <param name="path"> Path of document in storage. </param>
        /// <param name="etag"> The entity tag for this resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DocumentLocation(string path, ETag etag, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Path = path;
            Etag = etag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DocumentLocation"/> for deserialization. </summary>
        internal DocumentLocation()
        {
        }

        /// <summary> Path of document in storage. </summary>
        public string Path { get; }
        /// <summary> The entity tag for this resource. </summary>
        public ETag Etag { get; }
    }
}
