// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Health.Deidentification
{
    /// <summary> Response body for de-identification operation. </summary>
    public partial class DeidentificationResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DeidentificationResult"/>. </summary>
        internal DeidentificationResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DeidentificationResult"/>. </summary>
        /// <param name="outputText"> Output text after de-identification. Not available for "Tag" operation. </param>
        /// <param name="taggerResult"> Result of the "Tag" operation. Only available for "Tag" Operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DeidentificationResult(string outputText, PhiTaggerResult taggerResult, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OutputText = outputText;
            TaggerResult = taggerResult;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Output text after de-identification. Not available for "Tag" operation. </summary>
        public string OutputText { get; }
        /// <summary> Result of the "Tag" operation. Only available for "Tag" Operation. </summary>
        public PhiTaggerResult TaggerResult { get; }
    }
}
